% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/decompose.R
\name{decompose}
\alias{decompose}
\title{Decomposition of meaning of a finding or disorder SNOMED CT concept}
\usage{
decompose(
  conceptIds,
  diagnosis_text = NULL,
  CDB,
  SNOMED = getSNOMED(),
  noisy = FALSE,
  omit_unmatched = TRUE
)
}
\arguments{
\item{conceptIds}{vector of SNOMED CT concepts to decompose}

\item{diagnosis_text}{vector of SNOMED CT terms (or in theory any
text that has the same meaning as the SNOMED CT concept). If NULL,
decompositions are created for all SNOMED CT synonyms of the
concepts.}

\item{CDB}{an environment containing CDB files, as created by
createCDB}

\item{SNOMED}{an environment containing the SNOMED CT dictionary}

\item{noisy}{whether to output messages (for debugging)}

\item{omit_unmatched}{whether to omit rows in which some attributes
could not be matched to SNOMED CT concepts}
}
\value{
a SNOMEDfinding objects, which is a data.table with columns
  rootId (integer64), with (integer64), due_to (integer64),
  after (integer64), without (integer64), body_site (integer64),
  severity (integer64), stage (integer64), laterality (integer64),
  roottext (character), partId (integer64),
  other_conceptId (character, a string of SNOMED CT concept IDs
  separated by spaces), origId (integer64)
}
\description{
Decomposes a SNOMED CT term into separate components according
to the SNOMED CT information model and text parsing. Each term
may have a number of possible decompositions. Requires a CDB
environment created by createCDB.
}
\examples{
\dontrun{
miniCDB <- createCDB(SNOMED = sampleSNOMED())
D <- decompose(as.SNOMEDconcept('Cor pulmonale',
  SNOMED = sampleSNOMED()), CDB = miniCDB, SNOMED = sampleSNOMED())
}

# -------------------------------------------------------
# 83291003 | Cor pulmonale (disorder)
# -------------------------------------------------------
# Root : 367363000 | Right ventricular failure (disorder)
# - Due to : 19829001 | Disorder of lung (disorder)
}
