% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_geography.R
\name{get_geography}
\alias{get_geography}
\title{get_geography}
\usage{
get_geography(dataset, vintage = NULL)
}
\arguments{
\item{dataset}{A required string that sets the acronym name of the data set of interest (e.g. "acs/acs5")}

\item{vintage}{An optional numeric that sets the year of interest.}
}
\value{
A \code{data.table}
}
\description{
Get the list of geography entities available (state, county, tract, etc)
for a specific dataset.

Function produces a \code{data.table} of all the geography "name" and "geoLevelDisplay" variables
available for a specific dataset and optionally a vintage.
}
\examples{
library(jsonlite)
library(data.table)
library(httr2)
library(RcensusPkg)
# Get the geographies available for dataset "acs/acs1/profile" with vintage 2019
acs1_profile_geo_dt <- RcensusPkg::get_geography(
  dataset = "acs/acs1/profile",
  vintage = 2019
)

}
