% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/entropy_k_stage.R
\name{entropy_k_stage}
\alias{entropy_k_stage}
\title{Calculate Keyfitz entropy for a stage-based matrix population model}
\usage{
entropy_k_stage(Umat, init_distrib = NULL, max_age = NULL, n_is_maxage = FALSE)
}
\arguments{
\item{Umat}{A square numeric matrix representing the U submatrix of a
stage-based (Lefkovitch) matrix population model.}

\item{init_distrib}{The initial cohort distribution across
stages. This should sum to 1. If it does not sum to 1, the function
rescales it to 1. Defaults to an equal distribution across stages.}

\item{max_age}{The upper age, in units of the projection interval. Defaults
to 1000 if no information is provided.}

\item{n_is_maxage}{If TRUE, survival p_n is set to zero. Defaults to FALSE.}
}
\value{
Returns a single numeric value representing the Keyfitz entropy
for the given matrix. This value quantifies the dispersion of age at death.
}
\description{
Computes Keyfitz entropy from the U submatrix of a stage-based (Lefkovitch)
matrix population model.
}
\examples{
data(mpm1)

entropy_k_stage(mpm1$matU)
}
\references{
Keyfitz, N. 1977. Applied Mathematical Demography. New York:
  Wiley.
}
\seealso{
Other life history traits: 
\code{\link{entropy_d}()},
\code{\link{entropy_k}()},
\code{\link{entropy_k_age}()},
\code{\link{gen_time}()},
\code{\link{life_elas}()},
\code{\link{life_expect_mean}()},
\code{\link{longevity}()},
\code{\link{net_repro_rate}()},
\code{\link{repro_maturity}},
\code{\link{shape_rep}()},
\code{\link{shape_surv}()}
}
\author{
Stefano Giaimo <giaimo@evolbio.mpg.de>

Owen Jones <jones@biology.sdu.dk>
}
\concept{life history traits}
