% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/combine_rwd_agg.R
\name{rbind.rwd_agg}
\alias{rbind.rwd_agg}
\alias{cbind.rwd_agg}
\title{Combine RiverWare data aggregators}
\usage{
\method{rbind}{rwd_agg}(..., deparse.level = 1)

\method{cbind}{rwd_agg}(..., deparse.level = 1)
}
\arguments{
\item{...}{(generalized) vectors or matrices.  These can be given as named
    arguments.  Other \R objects may be coerced as appropriate, or S4
    methods may be used: see sections \sQuote{Details} and
    \sQuote{Value}.  (For the \code{"data.frame"} method of \code{cbind}
    these can be further arguments to \code{\link[base]{data.frame}} such as
    \code{stringsAsFactors}.)}

\item{deparse.level}{integer controlling the construction of labels in
    the case of non-matrix-like arguments (for the default method):\cr
    \code{deparse.level = 0} constructs no labels;\cr
    the default \code{deparse.level = 1} typically and
    \code{deparse.level = 2} always construct labels from the argument
    names, see the \sQuote{Value} section below.}
}
\description{
Take a sequence of \code{rwd_agg} arguments (or vector, matrix, or data.frames)
and combine by rows. If the objects are not \code{rwd_agg} objects they will be
combined through the default \code{rbind()} method, and then verified that they
meet all constraints to be a valid \code{rwd_agg} object. \code{cbind()} will fail for
\code{rwd_agg} objects.
}
\examples{

ra1 <- rwd_agg(data.frame(
  file = "KeySlots.rdf",
  slot = "Powell.Pool Elevation",
  period = "wy",
  summary = "min",
  eval = "<",
  t_s = 3550,
  variable = "powellLt3550",
  stringsAsFactors = FALSE
))

ra2 <- read_rwd_agg(
  system.file(
    "extdata/rwd_agg_files/passing_aggs.csv", 
    package = "RWDataPlyr"
  )
)

rbind(ra1, ra2)

\dontrun{
# will fail because you cannot have repeating variable names
rbind(ra1, ra1)

# will also fail
cbind(ra1, ra2)
}

}
