% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/skewt2.R
\name{skewt2}
\alias{skewt2}
\alias{dskewt2}
\alias{pskewt2}
\alias{qskewt2}
\alias{rskewt2}
\title{Moment-parameterised skew t distribution}
\usage{
dskewt2(x, mean = 0, sd = 1, skew = 0, df = 100, log = FALSE)

pskewt2(q, mean = 0, sd = 1, skew = 0, df = 100,
        method = 0, lower.tail = TRUE, log.p = FALSE)

qskewt2(p, mean = 0, sd = 1, skew = 0, df = 100, tol = 1e-08, method = 0)

rskewt2(n, mean = 0, sd = 1, skew = 0, df = 100)
}
\arguments{
\item{x, q}{vector of quantiles}

\item{mean}{mean parameter}

\item{sd}{standard deviation parameter, must be positive.}

\item{skew}{skewness parameter, can be positive or negative.}

\item{df}{degrees of freedom, must be positive.}

\item{log, log.p}{logical; if \code{TRUE}, probabilities/ densities \eqn{p} are returned as \eqn{\log(p)}.}

\item{method}{an integer value between 0 and 5 which selects the computing method; see ‘Details’ in the \code{\link[sn]{pst}} documentation below for the meaning of these values. If method=0 (default value), an automatic choice is made among the four actual computing methods, depending on the other arguments.}

\item{lower.tail}{logical; if \code{TRUE}, probabilities are \eqn{P[X \le x]}, otherwise, \eqn{P[X > x]}.}

\item{p}{vector of probabilities}

\item{tol}{a scalar value which regulates the accuracy of the result of qsn, measured on the probability scale.}

\item{n}{number of random values to return.}
}
\value{
\code{dskewt2} gives the density, \code{pskewt2} gives the distribution function, \code{qskewt2} gives the quantile function, and \code{rskewt2} generates random deviates.
}
\description{
Density, distribution function, quantile function, and random generation
for the skew t distribution reparameterised so that \code{mean} and \code{sd}
correspond to the \emph{true} mean and standard deviation.
}
\details{
This corresponds to the skew t type 2 distribution in GAMLSS (\code{\link[gamlss.dist]{ST2}}), see pp. 411-412 of Rigby et al. (2019) and the version implemented in the \code{sn} package.
However, it is reparameterised in terms of a standard deviation parameter \code{sd} rather than just a scale parameter \code{sigma}. Details of this reparameterisation are given below.
This implementation of \code{dskewt} allows for automatic differentiation with \code{RTMB} while the other functions are imported from the \code{sn} package.
See \code{sn::\link[sn]{dst}} for more details.

\strong{Caution:} In a numerial optimisation, the \code{skew} parameter should NEVER be initialised with exactly zero.
This will cause the initial and all subsequent derivatives to be exactly zero and hence the parameter will remain at its initial value.

For given \code{skew} \eqn{= \alpha} and \code{df} = \eqn{\nu}, define
\deqn{
\delta = \alpha / \sqrt{1 + \alpha^2}, \qquad
b_\nu = \sqrt{\nu / \pi}\, \Gamma((\nu-1)/2)/\Gamma(\nu/2),
}
then
\deqn{
E(X) = \mu + \sigma \delta b_\nu,\quad
Var(X) = \sigma^2 \left( \frac{\nu}{\nu-2} - \delta^2 b_\nu^2 \right).
}
}
\examples{
x <- rskewt2(1, 1, 2, 5, 5)
d <- dskewt2(x, 1, 2, 5, 5)
p <- pskewt2(x, 1, 2, 5, 5)
q <- qskewt2(p, 1, 2, 5, 5)
}
\seealso{
\link{skewt}, \link{skewnorm}, \link{skewnorm2}
}
