% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interface.R
\name{firstRun,RPhosFate-method}
\alias{firstRun,RPhosFate-method}
\alias{firstRun}
\title{First run}
\usage{
\S4method{firstRun}{RPhosFate}(x, substance = "PP")
}
\arguments{
\item{x}{An S4 \code{\linkS4class{RPhosFate}} river catchment object.}

\item{substance}{A character string specifying the substance to calculate.}
}
\value{
An S4 \code{\linkS4class{RPhosFate}} river catchment object and side effects in
the form of raster files.
}
\description{
Calls \code{\link{erosionPrerequisites}}, \code{\link{erosion}}, \code{\link{emission}},
\code{\link{transportPrerequisites}} and \code{\link{transport}} in the mentioned order. While
\code{\link{transport}} is called for the specified substance only, \code{\link{emission}} is
called for all substances whose top soil concentrations have been provided.
}
\examples{
\donttest{
# temporary demonstration project copy
cv_dir <- demoProject()
# load temporary demonstration project
x <- RPhosFate(
  cv_dir = cv_dir,
  ls_ini = TRUE
)

x <- firstRun(x, "SS")}

}
\seealso{
\code{\link{subsequentRun}}
}
