% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RMVL.R
\name{mvl_write_serialized_object}
\alias{mvl_write_serialized_object}
\title{Write R object in serialized form}
\usage{
mvl_write_serialized_object(MVLHANDLE, x, name = NULL)
}
\arguments{
\item{MVLHANDLE}{a handle to MVL file produced by mvl_open()}

\item{x}{a suitable R object (vector, array, list, data.frame) or a vector-like MVL_OBJECT}

\item{name}{if specified add a named entry to MVL file directory}
}
\value{
an object of class MVL_OFFSET that describes an offset into this MVL file. MVL offsets are vectors and can be concatenated. They can be written to MVL file directly, or as part of another object such as list.
}
\description{
This function packages the object into a raw vector before writing it out. The raw vector is tagged with 
special class that assures the object is automatically converted back to R representation when reading.
Serialized objects can only be read completely.
}
\details{
This function can be used in rare cases when it is important to store a complete R object, but it is not
important for it to be accessible by other programs, and it is not important to conserve memory or bandwidth.
}
\examples{
\dontrun{
Mtmp<-mvl_open("tmp_a.mvl", append=TRUE, create=TRUE)
mvl_write_serialized_object(Mtmp, lm(rnorm(100)~runif(100)), "LM1")
Mtmp<-mvl_remap(Mtmp)
print(mvl2R(Mtmp$LM1))
}
}
\seealso{
\code{\link{mvl_write_object}}
}
