/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.utilities;

import ec.tstoolkit.utilities.WeightedItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class WeightedItems<T>
implements Cloneable {
    private ArrayList<WeightedItem<T>> m_items = new ArrayList();

    public List<WeightedItem<T>> items() {
        return Collections.unmodifiableList(this.m_items);
    }

    public void clear() {
        this.m_items.clear();
    }

    public int getCount() {
        return this.m_items.size();
    }

    public WeightedItem<T> get(int idx) {
        return this.m_items.get(idx);
    }

    public void add(WeightedItem<T> item) {
        this.m_items.add(item);
    }

    public void add(Collection<WeightedItem<T>> items) {
        this.m_items.addAll(items);
    }

    public void removeAt(int pos) {
        this.m_items.remove(pos);
    }

    public boolean normalize() {
        double sum = this.getSumWeights();
        if (sum == 0.0) {
            return false;
        }
        for (WeightedItem<T> item : this.m_items) {
            item.weight /= sum;
        }
        return true;
    }

    public double getSumWeights() {
        double s = 0.0;
        for (WeightedItem<T> item : this.m_items) {
            s += item.weight;
        }
        return s;
    }

    public WeightedItems<T> clone() {
        try {
            WeightedItems items = (WeightedItems)super.clone();
            items.m_items = (ArrayList)this.m_items.clone();
            return items;
        }
        catch (CloneNotSupportedException ex) {
            throw new AssertionError();
        }
    }

    public static <T> boolean equals(WeightedItems<T> l, WeightedItems<T> r) {
        boolean[] used = new boolean[l.getCount()];
        for (WeightedItem<T> wc : l.m_items) {
            int idx;
            for (idx = 0; idx < used.length; ++idx) {
                WeightedItem<T> cur = r.m_items.get(idx);
                if (used[idx] || !cur.item.equals(wc.item) || cur.weight != wc.weight) continue;
                used[idx] = true;
                break;
            }
            if (idx != used.length) continue;
            return false;
        }
        return true;
    }
}

