/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.modelling.arima.demetra;

import ec.tstoolkit.arima.estimation.RegArimaEstimation;
import ec.tstoolkit.arima.estimation.RegArimaModel;
import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.eco.ConcentratedLikelihood;
import ec.tstoolkit.information.InformationSet;
import ec.tstoolkit.modelling.arima.AbstractSingleOutlierDetector;
import ec.tstoolkit.modelling.arima.ExactSingleOutlierDetector;
import ec.tstoolkit.modelling.arima.IOutliersDetectionModule;
import ec.tstoolkit.modelling.arima.ModelDescription;
import ec.tstoolkit.modelling.arima.ModellingContext;
import ec.tstoolkit.modelling.arima.ProcessingResult;
import ec.tstoolkit.modelling.arima.demetra.DemetraModule;
import ec.tstoolkit.sarima.SarimaModel;
import ec.tstoolkit.sarima.estimation.GlsSarimaMonitor;
import ec.tstoolkit.timeseries.TsPeriodSelector;
import ec.tstoolkit.timeseries.regression.AdditiveOutlierFactory;
import ec.tstoolkit.timeseries.regression.IOutlierFactory;
import ec.tstoolkit.timeseries.regression.IOutlierVariable;
import ec.tstoolkit.timeseries.regression.LevelShiftFactory;
import ec.tstoolkit.timeseries.regression.OutlierDefinition;
import ec.tstoolkit.timeseries.regression.SeasonalOutlierFactory;
import ec.tstoolkit.timeseries.regression.TransitoryChangeFactory;
import ec.tstoolkit.timeseries.simplets.TsDomain;
import ec.tstoolkit.utilities.Comparator;
import java.util.ArrayList;
import java.util.List;

public class OutliersDetectionModule
extends DemetraModule
implements IOutliersDetectionModule {
    private static final double EPS = 1.0E-5;
    private static int MAXROUND = 50;
    private static int MAXOUTLIERS = 24;
    private RegArimaModel<SarimaModel> regarima_;
    private final ArrayList<IOutlierVariable> outliers_ = new ArrayList();
    private final AbstractSingleOutlierDetector sod;
    private double[] tstats_;
    private int nhp_;
    private int round_;
    private boolean exit_;
    private IOutlierVariable lastremoved_;
    private TsPeriodSelector span_;
    private Estimation estimation = Estimation.ExactIterative;
    private Method method = Method.Tramo;
    private int selectivity_;
    private double cv_;
    private double curcv_;
    private double pc_ = 0.12;
    public static final double MINCV = 2.0;
    private static final String OUTLIERS = "Outliers detection";
    private static final String OUT_ADD = "Outlier added";
    private static final String OUT_REMOVE = "Outlier removed";
    private static final String VA = "Critical value";

    public Estimation getEstimation() {
        return this.estimation;
    }

    public void setEstimation(Estimation estimation) {
        this.estimation = estimation;
    }

    public Method getMethod() {
        return this.method;
    }

    public void setMethod(Method method) {
        this.method = method;
    }

    public OutliersDetectionModule() {
        this.sod = new ExactSingleOutlierDetector();
    }

    public OutliersDetectionModule(AbstractSingleOutlierDetector sod) {
        this.sod = sod;
    }

    @Override
    public ProcessingResult process(ModellingContext context) {
        this.clear();
        List<OutlierDefinition> initial = OutlierDefinition.of(context.description.getOutliers());
        if (this.curcv_ == 0.0) {
            this.curcv_ = this.calcCv(context);
        }
        this.addVaInfo(context, this.curcv_);
        TsDomain edomain = context.description.getEstimationDomain();
        this.sod.prepare(edomain, this.span_ == null ? null : edomain.select(this.span_));
        this.sod.exclude(context.description.getMissingValues());
        this.sod.exclude(context.description.getOutliersPosition(true));
        this.sod.exclude(context.description.getOutliersPosition(false));
        this.outliers_.addAll(context.description.getOutliers());
        this.regarima_ = context.description.buildRegArima();
        this.nhp_ = this.regarima_.getArima().getParametersCount();
        if (!this.estimateModel(true)) {
            return ProcessingResult.Failed;
        }
        try {
            switch (this.method.ordinal()) {
                case 0: {
                    this.calcTramo(context);
                    break;
                }
                case 1: {
                    this.calcX13(context);
                    break;
                }
                case 2: {
                    this.calcDemetra1(context);
                }
            }
            if (!Comparator.equals(initial, OutlierDefinition.of(this.outliers_))) {
                context.description.setOutliers(this.outliers_);
                this.addInfo(context.description, context.information);
                context.estimation = null;
                return ProcessingResult.Changed;
            }
            return ProcessingResult.Unchanged;
        }
        catch (RuntimeException err) {
            return ProcessingResult.Failed;
        }
    }

    private void calcTramo(ModellingContext context) {
        this.exit_ = false;
        while (this.sod.process(this.regarima_)) {
            ++this.round_;
            double max = this.sod.getMaxTStat();
            if (Math.abs(max) < this.curcv_) break;
            IOutlierVariable o = this.sod.getMaxOutlier();
            boolean bok = true;
            for (int i = 0; i < this.outliers_.size(); ++i) {
                if (!o.getPosition().equals((Object)this.outliers_.get(i).getPosition())) continue;
                bok = false;
                break;
            }
            if (!bok) break;
            this.addOutlier(o);
            this.addOutlierInfo(context, o, max);
            this.estimateModel(false);
            while (!this.verifyModel(context) && !this.exit_) {
                this.updateLikelihood(this.regarima_.computeLikelihood());
            }
            if (!this.exit_ && this.outliers_.size() != MAXOUTLIERS && this.round_ < MAXROUND) continue;
        }
        while (!this.verifyModel(context)) {
            this.estimateModel(false);
        }
    }

    private void calcX13(ModellingContext context) {
        while (this.sod.process(this.regarima_)) {
            ++this.round_;
            double max = this.sod.getMaxTStat();
            if (Math.abs(max) < this.curcv_) break;
            IOutlierVariable o = this.sod.getMaxOutlier();
            this.addOutlier(o);
            this.addOutlierInfo(context, o, max);
            this.estimateModel(false);
            if (this.outliers_.size() != MAXOUTLIERS && this.round_ < MAXROUND) continue;
        }
        while (!this.verifyModel(context)) {
            this.estimateModel(false);
        }
    }

    private void calcDemetra1(ModellingContext context) {
        while (this.sod.process(this.regarima_)) {
            ++this.round_;
            double max = this.sod.getMaxTStat();
            if (Math.abs(max) < this.curcv_) break;
            IOutlierVariable o = this.sod.getMaxOutlier();
            this.addOutlier(o);
            this.addOutlierInfo(context, o, max);
            if (this.outliers_.size() != MAXOUTLIERS && this.round_ < MAXROUND) continue;
        }
        this.estimateModel(true);
        while (!this.verifyModel(context)) {
            this.estimateModel(false);
        }
    }

    private boolean estimateModel(boolean full) {
        GlsSarimaMonitor monitor = this.monitor();
        monitor.setPrecision(1.0E-4);
        RegArimaEstimation<SarimaModel> est = full ? monitor.process(this.regarima_) : monitor.optimize(this.regarima_);
        this.regarima_ = est.model;
        this.updateLikelihood(est.likelihood);
        return true;
    }

    private void updateLikelihood(ConcentratedLikelihood likelihood) {
        this.tstats_ = likelihood.getTStats(true, this.nhp_);
    }

    private void clear() {
        this.nhp_ = 0;
        this.outliers_.clear();
        this.round_ = 0;
        this.lastremoved_ = null;
        this.tstats_ = null;
        this.curcv_ = 0.0;
    }

    private boolean verifyModel(ModellingContext context) {
        if (this.outliers_.isEmpty()) {
            return true;
        }
        int nx0 = this.regarima_.getVarsCount() - this.outliers_.size();
        int imin = 0;
        for (int i = 1; i < this.outliers_.size(); ++i) {
            if (!(Math.abs(this.tstats_[i + nx0]) < Math.abs(this.tstats_[imin + nx0]))) continue;
            imin = i;
        }
        if (Math.abs(this.tstats_[nx0 + imin]) >= this.curcv_) {
            return true;
        }
        IOutlierVariable toremove = this.outliers_.get(imin);
        this.sod.allow(toremove);
        this.removeOutlier(imin);
        this.removeOutlierInfo(context, toremove);
        if (this.lastremoved_ != null && toremove.getPosition().equals((Object)this.lastremoved_.getPosition()) && toremove.getOutlierType() == this.lastremoved_.getOutlierType()) {
            this.exit_ = true;
        }
        this.lastremoved_ = toremove;
        return false;
    }

    private void addOutlier(IOutlierVariable o) {
        this.outliers_.add(o);
        double[] xo = new double[this.regarima_.getObsCount()];
        DataBlock XO = new DataBlock(xo);
        o.data(this.sod.getDomain().getStart(), XO);
        this.regarima_.addX(XO);
        this.sod.exclude(o);
    }

    private void removeOutlier(int idx) {
        int opos = this.regarima_.getXCount() - this.outliers_.size() + idx;
        this.regarima_.removeX(opos);
        this.outliers_.remove(idx);
    }

    public void addOutlierFactory(IOutlierFactory o) {
        this.sod.addOutlierFactory(o);
    }

    public void clearOutlierFactories() {
        this.sod.clearOutlierFactories();
    }

    public void setAll() {
        this.clear();
        this.clearOutlierFactories();
        this.addOutlierFactory(new AdditiveOutlierFactory());
        LevelShiftFactory lfac = new LevelShiftFactory();
        lfac.setZeroEnded(true);
        this.addOutlierFactory(lfac);
        this.addOutlierFactory(new TransitoryChangeFactory());
        SeasonalOutlierFactory sfac = new SeasonalOutlierFactory();
        sfac.setZeroEnded(true);
        this.addOutlierFactory(sfac);
    }

    public int getOutlierFactoriesCount() {
        return this.sod.getOutlierFactoriesCount();
    }

    public void setDefault() {
        this.clear();
        this.clearOutlierFactories();
        this.addOutlierFactory(new AdditiveOutlierFactory());
        this.addOutlierFactory(new LevelShiftFactory());
        this.addOutlierFactory(new TransitoryChangeFactory());
        this.curcv_ = 0.0;
    }

    public void setCriticalValue(double value) {
        this.cv_ = value;
    }

    public double getCritivalValue() {
        return this.cv_;
    }

    public double getPc() {
        return this.pc_;
    }

    public void setPc(double pc) {
        this.pc_ = pc;
    }

    private double calcCv(ModellingContext context) {
        double cv = this.cv_;
        if (cv == 0.0) {
            cv = IOutliersDetectionModule.ICriticalValueComputer.defaultComputer().compute(context.description.getY().length);
        }
        for (int i = 0; i < -this.selectivity_; ++i) {
            cv *= 1.0 - this.pc_;
        }
        return Math.max(cv, 2.0);
    }

    private void addInfo(ModelDescription desc, InformationSet information) {
        InformationSet subset = information.subSet("outliers");
        subset.set("count", Integer.valueOf(desc.getOutliers().size()));
    }

    @Override
    public boolean reduceSelectivity() {
        if (this.curcv_ == 0.0) {
            return false;
        }
        --this.selectivity_;
        if (this.curcv_ == 2.0) {
            return false;
        }
        this.curcv_ = Math.max(2.0, this.curcv_ * (1.0 - this.pc_));
        return true;
    }

    @Override
    public void setSelectivity(int level) {
        if (this.selectivity_ != level) {
            this.selectivity_ = level;
            this.curcv_ = 0.0;
        }
    }

    @Override
    public int getSelectivity() {
        return this.selectivity_;
    }

    public void setSpan(TsPeriodSelector span) {
        this.span_ = span;
    }

    public TsPeriodSelector getSpan() {
        return this.span_;
    }

    private void addOutlierInfo(ModellingContext context, IOutlierVariable var, double t) {
    }

    private void removeOutlierInfo(ModellingContext context, IOutlierVariable var) {
    }

    private void addVaInfo(ModellingContext context, double va) {
    }

    public static enum Estimation {
        Approximate,
        ExactIterative,
        ExactFixed;

    }

    public static enum Method {
        Tramo,
        X13,
        Demetra1;

    }
}

