/*
 * Decompiled with CFR 0.152.
 */
package ec.businesscycle.simplets;

import ec.businesscycle.impl.HodrickPrescott;
import ec.tstoolkit.timeseries.simplets.TsData;
import ec.tstoolkit.timeseries.simplets.TsFrequency;

public class TsHodrickPrescott {
    private TsData cycle;
    private TsData trend;
    private double lambda = -1.0;
    private double cyclelen = 8.0;

    public void setLambda(double lambda) {
        this.lambda = lambda;
        this.cyclelen = -1.0;
    }

    public void setCycleLength(double len) {
        this.cyclelen = len;
        this.lambda = -1.0;
    }

    public double getLambda() {
        return this.lambda;
    }

    public double getCycleLength() {
        return this.cyclelen;
    }

    public boolean process(TsData s) {
        this.clear();
        HodrickPrescott hp = new HodrickPrescott();
        double lb = this.calcLambda(s.getFrequency());
        hp.setLambda(lb);
        if (!hp.process(s)) {
            return false;
        }
        this.trend = new TsData(s.getStart(), hp.getSignal(), false);
        this.cycle = TsData.subtract(s, this.trend);
        return true;
    }

    public TsData getCycle() {
        return this.cycle;
    }

    public TsData getTrend() {
        return this.trend;
    }

    public static double defaultLambda(double ylen, int freq) {
        double w = Math.PI * 2 / ((double)freq * ylen);
        double x = 1.0 - Math.cos(w);
        return 0.75 / (x * x);
    }

    private double calcLambda(TsFrequency frequency) {
        if (this.lambda > 0.0) {
            return this.lambda;
        }
        return TsHodrickPrescott.defaultLambda(this.cyclelen, frequency.intValue());
    }

    private void clear() {
        this.trend = null;
        this.cycle = null;
    }
}

