% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_star_system.R
\name{plot_star_system}
\alias{plot_star_system}
\title{Plot a Stylized Star System}
\usage{
plot_star_system(
  planet_data,
  spectral_type = " ",
  habitable_zone = c(0, 0),
  show_legend = FALSE
)
}
\arguments{
\item{planet_data}{A data frame containing planetary system data. Must include:
\itemize{
\item \code{pl_orbsmax}: semi-major axis (orbital distance),
\item \code{pl_rade}: planetary radius (in Earth radii),
\item \code{pl_dens}: planetary density (g/cm³).
}}

\item{spectral_type}{Optional character string indicating the star's spectral type.
Accepted values: \code{O}, \code{B}, \code{A}, \code{F}, \code{G}, \code{K}, \code{M}.}

\item{habitable_zone}{Optional numeric vector containing 2 values:
Inner and outer habitable zone edges in AU.}

\item{show_legend}{Optional bool value, whether to show plot legend.}
}
\value{
A ggplot2 object representing the planetary system visualization.
}
\description{
Creates a stylized polar plot of a planetary system,
displaying planets in circular orbits
around a central star. Planet size is scaled by radius,
orbit position is randomized for aesthetics,
planet color is mapped by density.
The star's color is optionally based on spectral type.
Optionally, star's habitable zone visualization can be overlayed.
}
\details{
The central star is positioned at the origin
with planets arranged in orbits of increasing radius.
Orbit lines are shown in gray for clarity.
}
\examples{
# Plot system GJ 682 (with hostid == "2.101289")
data = closest_50_exoplanets |>
  subset(hostid == 2.101289)
spectral_type = classify_star_spectral_type(data$st_teff[1])
plot_star_system(data,
                 spectral_type,
                 habitable_zone = calculate_star_habitable_zone(data$st_lum[1]))

}
