## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----setup, include=FALSE-----------------------------------------------------
library(REPS)
data("data_constraxion")

## -----------------------------------------------------------------------------
# Example dataset (you should already have this loaded)
head(data_constraxion)

## -----------------------------------------------------------------------------
dataset <- data_constraxion
dataset$floor_area <- log(dataset$floor_area)

## -----------------------------------------------------------------------------
Tbl_TD <- calculate_price_index(
  dataset = dataset,
  method = "timedummy",
  period_variable = "period",
  dependent_variable = "price",
  numerical_variables = c("floor_area", "dist_trainstation"),
  categorical_variables = c("dummy_large_city", "neighbourhood_code"),
  reference_period = 2015,
  number_of_observations = FALSE
)

head(Tbl_TD)

## -----------------------------------------------------------------------------
multi_result <- calculate_price_index(
  dataset = dataset,
  method = c("fisher", "paasche", "laspeyres"),
  period_variable = "period",
  dependent_variable = "price",
  numerical_variables = c("floor_area", "dist_trainstation"),
  categorical_variables = c("dummy_large_city", "neighbourhood_code"),
  reference_period = 2015,
  number_of_observations = FALSE
)

head(multi_result$fisher)
head(multi_result$paasche)
head(multi_result$laspeyres)

## ----echo=FALSE, out.width="100%", fig.align="center"-------------------------
knitr::include_graphics("multi_index.png")

