% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/REFA.R
\name{REFA_FN}
\alias{REFA_FN}
\title{Estimating Factor Numbers via Modified Rank Minimization}
\usage{
REFA_FN(Y, rmax = 8, tau = 0.75, q = 0.1, eps = 1e-04, init = TRUE)
}
\arguments{
\item{Y}{Input matrix, of dimension \eqn{T\times N}. Each row is an observation with \eqn{N} features at time point \eqn{t}.}

\item{rmax}{The bound of the number of factors.}

\item{tau}{Hyper parameter in selecting \eqn{\gamma} of the loss function.}

\item{q}{Hyper parameter used in the initializations, truncated PCA. Default is \code{0.05}.}

\item{eps}{The stopping criterion parameter. Default is \code{1e-5}.}

\item{init}{Warm start by truncated PCA algorithm. Default is \code{TRUE}.}
}
\value{
A list containing:
\item{rhat}{The estimated factor number.}
\item{Fhat}{The estimated factor matrix.}
\item{Lhat}{The estimated loading matrix.}
\item{loss}{The value of the loss function.}
}
\description{
Estimating Factor Numbers via Modified Rank Minimization
}
\examples{
\donttest{
# Assuming gendata() is defined in your package
dat = gendata()
REFA_FN(dat$Y, rmax = 8)
}
}
\references{
Robust factor analysis with exponential squared loss. Jiaqi Hu, Tingyin Wang, Xueqin Wang. Journal of Multivariate Analysis 2026, 213 105567; doi:10.1016/j.jmva.2025.105567
}
\author{
Jiaqi Hu
}
