% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/testpropsC.r
\name{testpropsC}
\alias{testpropsC}
\title{Tests the difference between two sample proportions, or difference between sample proportion and hypothesized value, with options for weighted observations, confidence intervals}
\usage{
testpropsC(x1, x2, w, data, dv, iv, digits = 3, response, printC = FALSE,
  ci.table = TRUE, ci.level = 95, ci.plot = TRUE, main, xlab, xlim, ...)
}
\arguments{
\item{x1}{A categorical variable}

\item{x2}{Value or variable to compare x1 against.}

\item{w}{(Optional) Weights variable.}

\item{data}{(Optional) Specify name of dataset (data frame) with x1 and x2 variables (or dv and iv).}

\item{dv}{Dependent variable}

\item{iv}{Independent variable, should have only two unique values. For comparison purposes, group1 will be first level of iv and group2 will be the second level of iv. To change order of groups, you can modify levels(iv).}

\item{digits}{(Optional) Number of digits to report after decimal place, optional (default: 3).}

\item{response}{(Optional) Identify the response value you wish to compare. If not specified, the function will compare first value of the dv (or x1 variable). If you want to group multiple responses together, use transformC to make dummy variable.}

\item{printC}{(Optional) Do you want results printed to .html file in your working directory? Default is FALSE. Set to TRUE to print results.}

\item{ci.table}{(Optional) Do you want a table reporting confidence interval of the difference of proportions? (default: TRUE)}

\item{ci.level}{(Optional) Desired confidence level, as percentage (default: 95)}

\item{ci.plot}{(Optional) Do you want a plot of the confidence interval of the difference of proportions? (default: TRUE)}

\item{main}{(Optional) Main title for plot of confidence interval of difference}

\item{xlab}{(Optional) Label for x-axis of plot of confidence interval of difference}

\item{xlim}{(Optional) A vector (of length 2) specifying the range of the x-axis, useful to zoom in on CI. By default, \code{xlim=c(-1, 1)}.}

\item{...}{(Optional) Additional arguments passed to plot function for the CI plot}
}
\value{
No return
}
\description{
Difference of proportions test with optional sample weights. Reports P-value of two-tailed significance test. Currently limited to testing one response from one dataset. If you want to compare x1 from dataset1 and x2 from dataset2, you can create new dataframe to test as dv ~ iv where dv is vector of x1 and x2 values and iv is vector identifying the source (i.e. dataset1 and dataset2). If you want to compare different responses, such as "Yes" value for x1 and "Agree" value for x2, you will need to transform one of the variables so they have comparable response values.
}
\section{RCPA3 Package Tutorial Videos}{

\itemize{
\item \href{https://www.youtube.com/watch?v=-2t2mwHeh_A}{Testing Proportions with RCPA3 Package's testpropsC Function} 27:33
\item \href{https://www.youtube.com/playlist?list=PL3jY4WDTUxoNqrxSSQH4q7XPLPYipeNCu}{Complete Playlist of RCPA3 Package Tutorial Videos}, includes video for this function and many more.
}
}

\section{Textbook References}{

\itemize{
\item Philip H. Pollock and Barry C. Edwards, \emph{An R Companion to Political Analysis, 3rd Edition} (Thousand Oaks, CA: Sage Publications, Forthcoming 2022), Chapter 9.
\item Philip H. Pollock and Barry C. Edwards, \emph{The Essentials of Political Analysis, 6th Edition} (Thousand Oaks, CA: Sage Publications, 2020), pp.201-215. ISBN-13: 978-1506379616; ISBN-10: 150637961.
}
}

\section{Online Resources}{

\itemize{
\item \href{https://www.poliscidata.com/pages/rDemosResources.php?chapter=9}{R Tutorials & Resources for Hypothesis Tests with One and Two Samples}, Compiled by Barry C. Edwards
\item \href{https://edge.sagepub.com/pollock}{Sage Edge Resources for Political Analysis Series}, for streaming videos, flashcards, and more student resources for textbooks by Pollock and Edwards, from Sage Publications.
\item \href{https://www.poliscidata.com}{Political Science Data Web Site}: Find datasets for your own research and resources to help with the analysis.
}
}

\examples{
   library(RCPA3)
   
   \dontrun{
   # one sample test: x1 variable against hypothesized value (of x2)
   testpropsC(x1=nes$gun.bg.checks, x2=.500, w=nes$wt, response="1. Favor a great deal", 
              xlim=c(0, .2))

   # two sample test x1 versus x2
   testpropsC(x1=approve.local.covid, x2=approve.pres.covid, w=wt, data=nes, 
              response="1. Approve strongly", xlim=c(0, .2))
   
   # test of proportions dv by iv
   testpropsC(dv=marital, iv=gender, w=wt, data=nes, response="3. Widowed", 
              xlim=c(-.10, 0))
   }
}
