% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Options.R
\name{RAthena_options}
\alias{RAthena_options}
\title{A method to configure RAthena backend options.}
\usage{
RAthena_options(
  file_parser,
  bigint,
  binary,
  json,
  cache_size,
  clear_cache,
  retry,
  retry_quiet,
  unload,
  clear_s3_resource,
  verbose
)
}
\arguments{
\item{file_parser}{Method to read and write tables to Athena, currently default to \code{"data.table"}. The file_parser also
determines the data format returned for example \code{"data.table"} will return \code{data.table} and \code{"vroom"} will return \code{tibble}.}

\item{bigint}{The R type that 64-bit integer types should be mapped to (default: \code{"integer64"}).
Inbuilt \code{bigint} conversion types \code{c("integer64", "integer", "numeric", "character")}.}

\item{binary}{The R type that "binary/varbinary" types should be mapped to (default \code{"raw"}).
Inbuilt binary conversion types \code{c("raw", "character")}.}

\item{json}{Attempt to converts AWS Athena data types arrays, json using \code{jsonlite:parse_json} (default: \code{"auto"}).
Inbuilt json conversion types \code{c("auto", "character")}.
Custom Json parsers can be provide by using a function with data frame parameter.}

\item{cache_size}{Number of queries to be cached. Currently only support caching up to 100 distinct queries (default: \code{0}).}

\item{clear_cache}{Clears all previous cached query metadata}

\item{retry}{Maximum number of requests to attempt (default: \code{5}).}

\item{retry_quiet}{This method is deprecated please use verbose instead.}

\item{unload}{set AWS Athena unload functionality globally (default: \code{FALSE})}

\item{clear_s3_resource}{Clear down \verb{AWS Athena} \verb{AWS S3} resource (\code{s3_staging_dir} location).
This is useful for users that don't have the \verb{AWS IAM role} permissions delete
from \code{s3_staging_dir} (default: \code{TRUE})}

\item{verbose}{print package info messages (default: \code{TRUE})}
}
\value{
\code{RAthena_options()} returns the \code{list} of athena option environment invisibly.
}
\description{
\code{RAthena_options()} provides a method to change the backend. This includes changing the file parser,
whether \code{RAthena} should cache query ids locally and number of retries on a failed api call.
}
\examples{
library(RAthena)

# change file parser from default data.table to vroom
RAthena_options("vroom")

# cache queries locally
RAthena_options(cache_size = 5)
}
