% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normalization.R
\name{RADnormalization}
\alias{RADnormalization}
\title{Normalizes an abundance vector to the desired number of ranks.}
\usage{
RADnormalization(
  input,
  max_rank,
  average_over = 1,
  min_rank = 1,
  labels = FALSE,
  count_data = TRUE,
  method = "upperlimit"
)
}
\arguments{
\item{input}{A vector which contains the abundance values (an abundance vector).}

\item{max_rank}{The desired rank to which this method normalizes the input.}

\item{average_over}{Number of times, a normalized RAD is created and averaged to
produce the result.}

\item{min_rank}{The minimum rank to which this method normalizes the input.}

\item{labels}{A logical. If \code{TRUE} the label of each rank (ids in the input vector)
will be returned.}

\item{count_data}{A logical. \code{TRUE} means that the input vector contains counts
(integer values) otherwise contains the relative abundances. In the current version only counts are accepted.}

\item{method}{Sets the stop criterion for normalization. This should be one of
"lowerlimit", "middle" or
"upperlimit". Method affects the final result.
lowerlimit: Samples from species pool one by one, until reaches max_rank.
middle: Samples from species pool with random size until the sampled vector has desired ranks (max_rank).
upperlimit: Removes from species pool one by one, until reaches max_rank.}
}
\value{
A list of following items:

$norm_rad: Normalized RAD sum up to 1. If \code{labels = TRUE}, it would also contain the labels.

$norm_rad_count:  A matrix of \code{average_over} rows and \code{max_rank} columns.
    Each row contains one normalized RAD. These normalized RADs are averaged and sum up to 1 in order to make norm_rad

$norm_rad_mean_sd: Standard deviation of the mean for all the ranks in \code{norm_rad}.
    This vector is created using the values in \code{norm_rad_count}

$inputs: A list which contains inputs used for creating normalized RADs.
}
\description{
Normalizes an abundance vector to the desired number of ranks.
}
\examples{
data("gut_otu_table")
rads <- gut_otu_table
original_rad <- sort(rads[1,],decreasing = TRUE)
#removing zeros
original_rad <- original_rad[original_rad > 0]
plot(original_rad,ylim = c(1,max(original_rad)),log = "xy", xlab = "Rank",ylab = "Abundance",
     main = "RAD of first sample",pch = 19,type = "b",cex = 0.5)
print(paste("number of ranks present in the original rad is:",length(original_rad)))
norm_rad <- RADnormalization(input = rads[1,],max_rank = 500,average_over = 50)
points(x = norm_rad$norm_rad * sum(norm_rad$norm_rad_count[1,]) ,pch = 19,cex = 1, type = "l",
       col = "blue",lwd = 4)
points(x = norm_rad$norm_rad_count[1,],pch = 19,cex = 1, type = "l",col = "red",lwd = 3)
points(x = norm_rad$norm_rad_count[2,],pch = 19,cex = 1, type = "l",col = "green",lwd = 3)
legend("bottomleft",legend = c("Original RAD","possible norm rad","possible norm rad",
                               paste("nrad averaged over 50 realizations, times",
                               sum(norm_rad$norm_rad_count[1,]))),
       col = c("black","red","green","blue"),lwd = 2,bty = "n")
}
\seealso{
\code{\link{RADnormalization_matrix}} for normalize an entire otutable,
         \code{\link{representative_point}} for study the representative of groups of samples in a multi-dimensional scaling plot,
         \code{\link{representative_RAD}} for study the representative of group of norm rads.
}
