% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_life_expectancy.R
\name{calc_gompertz_mode}
\alias{calc_gompertz_mode}
\title{Calculate Gompertz mode for a given life expectancy}
\usage{
calc_gompertz_mode(life_expectancy, current_age, dispersion, max_age = 120)
}
\arguments{
\item{life_expectancy}{A numeric. Desired life expectancy.}

\item{current_age}{A numeric. Current age.}

\item{dispersion}{A numeric. Dispersion of the Gompertz distribution.}

\item{max_age}{A numeric. Maximum age. Defaults to 120.}
}
\value{
A numeric. Mode of the Gompertz distribution.
}
\description{
Calculate Gompertz mode for a given life expectancy
}
\examples{
calc_gompertz_mode(
 life_expectancy = 86,
  current_age    = 25,
  dispersion     = 8.88,
  max_age        = 115
)
}
