% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/show_diff.R
\name{show_diff}
\alias{show_diff}
\title{Compare two texts or files with diffobj}
\usage{
show_diff(input1, input2)
}
\arguments{
\item{input1}{A character string. Either a file path or text content to compare.}

\item{input2}{A character string. Either a file path or text content to compare.}
}
\value{
A diffobj object containing the visual comparison of the two inputs.
}
\description{
This function compares two inputs (files or text strings) and displays
the differences using the diffobj package with syntax highlighting.
}
\examples{
# Compare two text strings
show_diff("Hello\nWorld", "Hello\nR World")

# Compare two files
\dontrun{
show_diff("file1.txt", "file2.txt")
}

# Mix file and text
\dontrun{
show_diff("file.txt", "New content\nWith changes")
}

}
