% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{predict.quanda}
\alias{predict.quanda}
\title{Make Predictions from a `quanda` Object}
\usage{
\method{predict}{quanda}(object, newx, type = c("class", "loss"), ...)
}
\arguments{
\item{object}{Fitted `quanda()` object from which predictions are to be derived.}

\item{newx}{Matrix of new predictor values for which predictions are desired.
This must be a matrix and is a required argument.}

\item{type}{Type of prediction required. Type `"class"` produces the predicted binary class labels and
type `"loss"` returns the fitted values. Default is \code{"class"}.}

\item{...}{Not used.}
}
\value{
Numeric vector of length \code{n_new}.
}
\description{
Produces fitted values for new predictor data using a fitted `quanda()` object.
}
\examples{
data(breast)
X <- as.matrix(X)
y <- as.numeric(as.character(y))
y[y==-1]=0
\donttest{fit <- quanda(X, y)}
}
\seealso{
\code{\link{quanda}}
}
