% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qbms.R
\name{list_trials}
\alias{list_trials}
\title{List Trials in the Current Active Breeding Program}
\usage{
list_trials(year = NULL)
}
\arguments{
\item{year}{Numeric. An optional parameter to filter trials by their starting year. 
If not provided, all trials for the active program are returned.}
}
\value{
A data frame containing the names of trials for the active breeding program. If no 
trials match the query, a warning is issued, and NA is returned.
}
\description{
Retrieves the list of trials for the current active breeding program. Optionally, 
filters trials by their starting year if specified.
}
\note{
The year filter is only supported for BMS databases.
}
\examples{
if (interactive()) {
  set_qbms_config("https://bms.icarda.org/ibpworkbench")
  login_bms()  # Log in to the server
  set_crop("wheat")  # Set crop
  set_program("Wheat International Nurseries")  # Set breeding program
  list_trials()  # List trials
  list_trials(2022)  # List trials starting in 2022
}

}
\seealso{
\code{\link{login}}, \code{\link{set_crop}}, \code{\link{set_program}} for related operations involving crop and program selection.
}
\author{
Khaled Al-Shamaa (\email{k.el-shamaa@cgiar.org})
}
