% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pedigree.R
\name{build_pedigree_table}
\alias{build_pedigree_table}
\title{Building Pedigree Table Recursively}
\usage{
build_pedigree_table(
  geno_list = NULL,
  pedigree_list = NULL,
  pedigree_df = NULL
)
}
\arguments{
\item{geno_list}{A character vector of genotype/germplasm names.}

\item{pedigree_list}{A character vector of associated pedigree strings, corresponding to the genotypes in \code{geno_list}.}

\item{pedigree_df}{A data frame of pedigrees from a previous iteration, used to accumulate pedigree data. If NULL, a new data frame is created.}
}
\value{
A data frame with three columns: 
  - `Variety`: The identifier for the individual genotype.
  - `Female`: The identifier for the female parent.
  - `Male`: The identifier for the male parent.
The pedigree is built recursively, with individuals listed before any appearance as a parent.
}
\description{
Recursively builds a pedigree table by extracting and tracking parents for each genotype/germplasm in the provided list. 
The function handles backcross cases and updates the pedigree data frame with parent information for multiple generations.
}
\author{
Khaled Al-Shamaa, \email{k.el-shamaa@cgiar.org}
}
