% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/method-puniform.R
\name{method.puniform}
\alias{method.puniform}
\title{puniform (P-Uniform) Method}
\usage{
\method{method}{puniform}(method_name, data, settings)
}
\arguments{
\item{method_name}{Method name (automatically passed)}

\item{data}{Data frame with yi (effect sizes) and sei (standard errors)}

\item{settings}{List of method settings (see Details)}
}
\value{
Data frame with P-Uniform results
}
\description{
Implements the p-uniform method for publication bias detection and correction.
P-uniform uses the distribution of p-values from significant studies to test
for publication bias and estimate the effect size corrected for publication bias.
The method assumes that p-values follow a uniform distribution under the null
hypothesis of no effect, and uses this to detect and correct for bias. See
\insertCite{vanassen2015meta;textual}{PublicationBiasBenchmark} and
\insertCite{vanaert2025puniform;textual}{PublicationBiasBenchmark} for details.
}
\details{
The following settings are implemented \describe{
\item{\code{"default"}}{Default p-uniform analysis settings.}
\item{\code{"star"}}{P-uniform star version of the method.}
}
}
\examples{
# Generate some example data
data <- data.frame(
  yi = c(0.2, 0.3, 0.1, 0.4, 0.25),
  sei = c(0.1, 0.15, 0.08, 0.12, 0.09)
)

# Apply puniform method
result <- run_method("puniform", data)
print(result)

}
\references{
\insertAllCited{}
}
