% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ranking.R
\name{ranking}
\alias{ranking}
\title{Flexible Ranking Utility}
\usage{
ranking(
  v,
  direction = c("asc", "desc"),
  ties = c("average", "min", "max", "first", "random"),
  na.last = c("keep", "bottom", "top"),
  dense = FALSE
)
}
\arguments{
\item{v}{Numeric (or coercible) vector to rank.}

\item{direction}{Character, one of \code{"asc"} or \code{"desc"}.}

\item{ties}{Character, tie-breaking: one of
\code{"average"}, \code{"min"}, \code{"max"}, \code{"first"}, \code{"random"}.}

\item{na.last}{Character, placement of NAs: \code{"keep"}, \code{"bottom"}, or \code{"top"}.}

\item{dense}{Logical; if \code{TRUE}, returns dense ranks (1,2,3,...) without gaps.}
}
\value{
An integer/numeric vector of ranks, same length as \code{v}.
}
\description{
A thin wrapper around base \code{\link[base]{rank}} with support for
ascending/descending order, multiple tie strategies, NA placement,
and dense ranks.
}
\examples{
ranking(c(3, 3, 2, NA, 5), direction="asc", ties="min", na.last="bottom")
ranking(c(3, 3, 2, 5), direction = "desc", dense = TRUE)
Gen=c("G1","G2","G3")
YN=c(10,8,5)
YS=c(7,5,3)
a=STI(Gen, YN, YS) # for instance STI taken here.
out=data.frame(a$Result$Gen, a$Result$STI,
ranking(a$Result$STI, direction="desc")
)
print(out)
}
