% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RachevRatio.R
\name{RachevRatio}
\alias{RachevRatio}
\title{Rachev Ratio}
\usage{
RachevRatio(
  R,
  alpha = 0.1,
  beta = 0.1,
  rf = 0,
  SE = FALSE,
  SE.control = NULL,
  ...
)
}
\arguments{
\item{R}{Data of returns for one or multiple assets or portfolios.}

\item{alpha}{Lower tail probability.}

\item{beta}{Upper tail probability.}

\item{rf}{Risk-free interest rate.}

\item{SE}{TRUE/FALSE whether to ouput the standard errors of the estimates of the risk measures, default FALSE.}

\item{SE.control}{Control parameters for the computation of standard errors. Should be done using the \code{\link{RPESE.control}} function.}

\item{...}{Additional parameters.}
}
\value{
A vector or a list depending on \code{se.method}.
}
\description{
\code{RachevRatio} computation with standard errors.
}
\details{
The Rachev ratio, introducted in Rachev et al. (2008), is a non-parametric estimator of the upper tail reward potential relative to the 
lower tail risk in a non-Gaussian setting, and as such, it is particularly useful when returns have a fat-tailed and possibly skewed distribution.
For small \eqn{\alpha} and \eqn{\beta}, it is a measure of the potential of extreme positive returns to risk of extremel negative returns.

For lower tail parameter \eqn{\alpha} and lower tail parameter \eqn{\beta}, the Rachev ratio is given by 

\deqn{\frac{ETL_{\alpha}(R_{f}-R_{a})}{ETL_{\beta}(R_{a}-R_{f})}}.
}
\examples{
# Loading data from PerformanceAnalytics
data(edhec, package = "PerformanceAnalytics")
class(edhec)
# Changing the data colnames
names(edhec) = c("CA", "CTA", "DIS", "EM", "EMN",
                 "ED", "FIA", "GM", "LS", "MA",
                 "RV", "SS", "FOF")
# Compute Rachev ratio for managers data
RachevRatio(edhec)

}
\references{
Rachev, Svetlozar T. et al. (2008). Advanced Stochastic Models, 
Risk Assessment, and Portfolio Optimization (1st ed.)
}
\author{
Anthony-Alexander Christidis, \email{anthony.christidis@stat.ubc.ca}
}
