% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotWMD.R
\name{plotWMD}
\alias{plotWMD}
\title{Plot Whistle Contour}
\usage{
plotWMD(data, id = 1, ...)
}
\arguments{
\item{data}{either a \code{PamBinary} class object, or just the \code{$data} from
a PamBinary object, or a single detection from the \code{$data}}

\item{id}{the id of the whistle to plot, either an index or Pamguard UID}

\item{\dots}{parameters to pass to other functions}
}
\value{
A ggplot object
}
\description{
Plots the entire whistle contour saved in a Pamguard Whistle &
  Moan Detector binary file, highlighting the selected contour
}
\examples{

# load example whistle file
wmFile <- system.file('extdata', 'WM.pgdf', package='PamBinaries')
wmData <- loadPamguardBinaryFile(wmFile)
plotWMD(wmData, 1)
plotWMD(wmData, 2)

}
\author{
Taiki Sakai \email{taiki.sakai@noaa.gov}
}
