% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PVBcorrect_functions.R
\name{acc_ipb}
\alias{acc_ipb}
\title{PVB correction by inverse probability bootstrap sampling (IPB)}
\usage{
acc_ipb(
  data,
  test,
  disease,
  covariate = NULL,
  saturated_model = FALSE,
  option = 2,
  ci = FALSE,
  ci_level = 0.95,
  ci_type = "norm",
  b = 1000,
  seednum = NULL,
  return_data = FALSE,
  return_detail = FALSE,
  description = TRUE
)
}
\arguments{
\item{data}{A data frame, with at least "Test" and "Disease" variables.}

\item{test}{The "Test" variable name, i.e. the test result. The variable must be in binary; positive = 1, negative = 0 format.}

\item{disease}{The "Disease" variable name, i.e. the true disease status. The variable must be in binary; positive = 1, negative = 0 format.}

\item{covariate}{The name(s) of covariate(s), i.e. other variables associated with either test or disease status.
Specify as name vector, e.g. c("X1", "X2") for two or more variables. The variables must be in formats acceptable to GLM.}

\item{saturated_model}{Set as \code{TRUE} to obtain the original Begg and Greenes' (1983) when all possible interactions are included.}

\item{option}{1 = IPW weight, 2 = W_h weight, described in Arifin (2023), modified weight of Krautenbacher (2017).
The default is \code{option = 2}. For small weights, \code{option = 2} is more stable (Arifin, 2023).}

\item{ci}{View confidence interval (CI). The default is \code{FALSE}.}

\item{ci_level}{Set the CI width. The default is 0.95 i.e. 95\% CI.}

\item{ci_type}{Set confidence interval (CI) type. Acceptable types are "norm", "basic", "perc", and "bca",
for bootstrapped CI.}

\item{b}{The number of bootstrap samples, b.}

\item{seednum}{Set the seed number for the bootstrapped CI. The default is not set, so it depends on the user
to set it outside or inside the function.}

\item{return_data}{Return data for the bootstrapped samples.}

\item{return_detail}{Return accuracy measures for each of the bootstrapped samples.}

\item{description}{Print the name of this analysis. The default is \code{TRUE}. This can be turned off for repeated analysis, for example in bootstrapped results.}
}
\value{
A list object containing:
\describe{
  \item{data_each_sample}{Raw data for each bootstrap sample, available with \code{return_data = TRUE}}
  \item{acc_each_sample}{Accuracy results for each bootstrap sample, available with \code{return_detail = TRUE}}
  \item{acc_results}{The accuracy results.}
}
}
\description{
Perform PVB correction by inverse probability bootstrap sampling.
}
\examples{
# point estimates
acc_ipb(data = cad_pvb, test = "T", disease = "D", b = 100, seednum = 12345)
acc_ipb(data = cad_pvb, test = "T", disease = "D", covariate = "X3",
        b = 100, seednum = 12345)

# with confidence interval
acc_ipb(data = cad_pvb, test = "T", disease = "D", ci = TRUE,
        b = 100, seednum = 12345)  # use small b for testing
}
\references{
\enumerate{
  \item{Arifin, W. N., & Yusof, U. K. (2022). Partial Verification Bias Correction Using Inverse Probability Bootstrap Sampling for Binary Diagnostic Tests. Diagnostics, 12(11), 2839.}
  \item{Arifin, W. N. (2023). Partial verification bias correction in diagnostic accuracy studies using propensity score-based methods (PhD thesis, Universiti Sains Malaysia). https://erepo.usm.my/handle/123456789/19184}
  \item{Krautenbacher, N., Theis, F. J., & Fuchs, C. (2017). Correcting Classifiers for Sample Selection Bias in Two-Phase Case-Control Studies. Computational and Mathematical Methods in Medicine, 2017, 1–18.}
  \item{Nahorniak, M., Larsen, D. P., Volk, C., & Jordan, C. E. (2015). Using inverse probability bootstrap sampling to eliminate sample induced bias in model based analysis of unequal probability samples. PLoS One, 10(6), e0131765.}
}
}
