% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/C00-weighted-km.R
\name{print.weightedKM}
\alias{print.weightedKM}
\title{Print Method for Weighted Kaplan-Meier Estimates}
\usage{
\method{print}{weightedKM}(x, print.digits = 3, print.rows = 10, ...)
}
\arguments{
\item{x}{An object of class "weightedKM" from \code{weightedKM()}.}

\item{print.digits}{Number of decimal places for printed output. Default 3.}

\item{print.rows}{Number of rows to print for each treatment group. Default 10.}

\item{...}{Additional arguments (currently unused).}
}
\value{
Invisibly returns the input object \code{x}.
}
\description{
Prints a summary of weighted Kaplan-Meier survival estimates.
}
\examples{
\donttest{
data(simdata_bin)
result <- weightedKM(
  data = simdata_bin,
  treatment_var = "Z",
  time_var = "time",
  event_var = "event",
  weight_method = "none"
)
print(result)
}

}
