# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' @title PPMR Summary-level Analysis
#' @name PMR_summary
#'
NULL

#'
#' @param betaxin Numeric vector of estimated SNP–exposure effects (length `p`).
#' @param betayin Numeric vector of estimated SNP–outcome effects (length `p`).
#' @param Sigma1sin Numeric `p x p` covariance matrix for the exposure SNP
#'   associations (typically an LD matrix).
#' @param Sigma2sin Numeric `p x p` covariance matrix for the outcome SNP
#'   associations.
#' @param samplen1 Integer. Sample size used to estimate \code{betaxin}.
#' @param samplen2 Integer. Sample size used to estimate \code{betayin}.
#' @param gammain Integer flag (0/1). If 1, constrains the gamma parameter to 0.
#' @param alphain Integer flag (0/1). If 1, constrains the alpha parameter to 0.
#' @param max_iterin Integer. Maximum number of EM iterations (default: 50 or more).
#' @param epsin Numeric. Convergence tolerance for the log-likelihood.
#'
#' @return A named list with elements:
#' \item{alpha}{Estimated causal effect of the mediator on the outcome.}
#' \item{gamma}{Estimated direct effect of the SNPs on the outcome.}
#' \item{sigmaX}{Residual variance for the exposure model.}
#' \item{sigmaY}{Residual variance for the outcome model.}
#' \item{sigmabeta}{Variance of the genetic effects.}
#' \item{loglik_seq}{Vector of log-likelihood values across iterations.}
#' \item{loglik}{Final log-likelihood value.}
#' \item{iteration}{Number of iterations used before convergence.}
#'
#' @examples
#' # ---- Simulate simple example data ----
#' set.seed(123)
#' p  <- 3
#' n1 <- 10
#' n2 <- 12
#' betax <- c(0.2, -0.1, 0.3)
#' betay <- c(0.1,  0.0, 0.2)
#' Sigma1 <- matrix(c(0.6, 0.2, 0.1,
#'                    0.2, 0.5, 0.1,
#'                    0.1, 0.1, 0.4), 3, 3)
#' Sigma2 <- matrix(c(0.5, 0.1, 0.0,
#'                    0.1, 0.6, 0.1,
#'                    0.0, 0.1, 0.5), 3, 3)
#'
#' PMR_summary(
#'   betaxin   = betax,
#'   betayin   = betay,
#'   Sigma1sin = Sigma1,
#'   Sigma2sin = Sigma2,
#'   samplen1  = n1,
#'   samplen2  = n2,
#'   gammain   = 0,
#'   alphain   = 0,
#'   max_iterin = 50,
#'   epsin      = 1e-6
#' )
#' @export
PMR_summary <- function(betaxin, betayin, Sigma1sin, Sigma2sin, samplen1, samplen2, gammain, alphain, max_iterin, epsin) {
    .Call(`_PPMR_PMR_summary`, betaxin, betayin, Sigma1sin, Sigma2sin, samplen1, samplen2, gammain, alphain, max_iterin, epsin)
}

#' @title PPMR Individual-level Analysis
#' @name PMR_individual
NULL

#'
#' @param yin Numeric vector of the outcome variable (length \eqn{n1}).
#' @param zin Numeric vector of the mediator variable (length \eqn{n2}).
#' @param x1in Numeric \eqn{n1 \times p} matrix of SNP genotypes for the
#'   outcome model.
#' @param x2in Numeric \eqn{n2 \times p} matrix of SNP genotypes for the
#'   mediator model.  Must have the same number of columns \eqn{p} as \code{x1in}.
#' @param gammain Integer flag (0/1). If 1, constrains the gamma parameter to 0.
#' @param alphain Integer flag (0/1). If 1, constrains the alpha parameter to 0.
#' @param max_iterin Integer. Maximum number of EM iterations (default: 50 or more).
#' @param epsin Numeric. Convergence tolerance for the log-likelihood.
#'
#' @return A named list with elements:
#' \item{alpha}{Estimated causal effect of the mediator on the outcome.}
#' \item{gamma}{Estimated direct effect of the SNPs on the outcome.}
#' \item{sigmaX}{Residual variance of the outcome model.}
#' \item{sigmaY}{Residual variance of the mediator model.}
#' \item{sigmabeta}{Variance of the genetic effects.}
#' \item{loglik_seq}{Vector of log-likelihood values across iterations.}
#' \item{loglik}{Final log-likelihood value.}
#' \item{iteration}{Number of iterations before convergence.}
#'
#' @examples
#' # ---- Simulate simple example data ----
#' set.seed(456)
#' n1 <- 8
#' n2 <- 10
#' p  <- 3
#'
#' # Outcome and mediator vectors
#' y <- c(0.5, -0.3, 0.1, 0.4, -0.2, 0.0, 0.6, -0.1)
#' z <- c(0.2, -0.4, 0.3, 0.1, -0.1, 0.5, 0.0, 0.4, -0.3, 0.2)
#'
#' # Fixed genotype design matrices (n × p) with mild correlations
#' x1 <- matrix(c(
#'   1.0, 0.2, 0.1,
#'   0.2, 1.0, 0.3,
#'   0.1, 0.3, 1.0,
#'   0.4, 0.1, 0.2,
#'   0.2, 0.4, 0.3,
#'   0.3, 0.2, 0.4,
#'   0.5, 0.1, 0.3,
#'   0.1, 0.5, 0.2
#' ), nrow = n1, byrow = TRUE)
#'
#' x2 <- matrix(c(
#'   1.0, 0.3, 0.2,
#'   0.3, 1.0, 0.4,
#'   0.2, 0.4, 1.0,
#'   0.5, 0.1, 0.3,
#'   0.2, 0.5, 0.1,
#'   0.3, 0.2, 0.4,
#'   0.4, 0.3, 0.2,
#'   0.1, 0.4, 0.3,
#'   0.2, 0.1, 0.5,
#'   0.3, 0.2, 0.4
#' ), nrow = n2, byrow = TRUE)
#'
#' # Run PPMR individual-level analysis
#' PMR_individual(
#'   yin        = y,
#'   zin        = z,
#'   x1in       = x1,
#'   x2in       = x2,
#'   gammain    = 0,
#'   alphain    = 0,
#'   max_iterin = 50,
#'   epsin      = 1e-6
#' )
#' 
#' @export
PMR_individual <- function(yin, zin, x1in, x2in, gammain, alphain, max_iterin, epsin) {
    .Call(`_PPMR_PMR_individual`, yin, zin, x1in, x2in, gammain, alphain, max_iterin, epsin)
}

