% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compnc.R
\name{compnc}
\alias{compnc}
\title{Calculate Phylogenetic Niche Conservatism Across Multiple Communities}
\usage{
compnc(
  com,
  trait_data,
  phylo_tree,
  methods = c("lambda", "K"),
  pca_axes = c("PC1", "PC2"),
  sig_levels = c(0.001, 0.01, 0.05),
  min_abundance = 0,
  nsim = 1000,
  verbose = TRUE
)
}
\arguments{
\item{com}{A community matrix with sites as rows and species as columns}

\item{trait_data}{A data frame or matrix containing trait data with species as rows}

\item{phylo_tree}{A phylogenetic tree object of class "phylo"}

\item{methods}{Character vector specifying methods to use. Options: "lambda", "K"}

\item{pca_axes}{Character vector specifying which PCA axes to include (e.g., c("PC1", "PC2"))}

\item{sig_levels}{Numeric vector of significance levels for marking results}

\item{min_abundance}{Minimum abundance threshold for including species}

\item{nsim}{Number of permutations for significance testing}

\item{verbose}{Logical indicating whether to show progress and warnings}
}
\value{
A data frame containing phylogenetic signal results for all communities
}
\description{
This function conducts comprehensive phylogenetic niche conservatism analysis across multiple
communities simultaneously. It evaluates phylogenetic signal for trait data across different
community assemblages using various statistical methods, enabling comparative assessment of
niche conservatism patterns among communities. The function processes community composition
matrices, species trait information, and phylogenetic trees to determine whether closely
related species consistently occupy similar ecological niches across different habitats
or sampling locations.
}
\examples{
\donttest{
#' # Load example data
data(BCI)
data(TRY)

# Extract trait data
sp <- colnames(BCI$com)
subtraits <- extract_traits(sp, TRY, rank = "species",
                           traits = c("LA", "LMA", "LeafN", "PlantHeight", "SeedMass", "SSD"))

compnc(com = BCI$com, subtraits, BCI$phy_species, methods = "lambda", pca_axes = NULL)
}

}
