% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Fishlife.R
\docType{data}
\name{Fishlife}
\alias{Fishlife}
\title{Fishlife Dataset}
\format{
A data frame with multiple variables:
\describe{
  \item{species}{Scientific species name}
  \item{genus}{Genus of the fish species}
  \item{family}{Family classification}
  \item{age_max}{Maximum age, years}
  \item{trophic_level}{Trophic level, where 1 is primary producers, etc., dimensionless}
  \item{aspect_ratio}{Caudal fin height and length divided by area, dimensionless}
  \item{fecundity}{Annual eggs produced, number/year}
  \item{growth_coefficient}{von Bertalannffy growth coefficient, year-1}
  \item{temperature}{Average temperature from portion of population sampled, celcius}
  \item{length_max}{maximum length, cm}
  \item{length_infinity}{von Bertalanffy asymptotic maximum length, cm}
  \item{length_maturity}{Length at 50\% maturity, cm}
  \item{age_maturity}{Age at 50\% sexual maturity, years}
  \item{natural_mortality}{Natural mortality rate M, year-1}
  \item{weight_infinity}{Asymptotic maximum weight, g}
  \item{max_body_depth}{Maximum body depth, cm}
  \item{max_body_width}{Maximum body width, cm}
  \item{lower_jaw_length}{Length of lower jaw, cm}
  \item{min_caudal_pedoncule_depth}{Depth of caudal pedoncule, connecting caudal fin to body}
  \item{offspring_size}{Size of offspring, kg}
}
}
\usage{
Fishlife
}
\description{
A comprehensive dataset of fish life history traits across multiple species,
compiled by Thorson et al. (2023). The dataset provides various morphological,
ecological, and biological characteristics of fish species.
}
\examples{
data(Fishlife)
head(Fishlife)
}
\references{
Thorson, J. T., Maureaud, A. A., Frelat, R., Mérigot, B., Bigman, J. S., Friedman, S. T., Palomares, M. L. D., Pinsky, M. L., Price, S. A., & Wainwright, P. (2023). Identifying direct and indirect associations among traits by merging phylogenetic comparative methods and structural equation models. Methods in Ecology and Evolution, 14(5), 1243-1255.
 \doi{10.1111/2041-210X.14076}
}
\keyword{datasets}
