#' @title Himalayan Birds Dataset
#'
#' @description
#' The `HimalayanBirds` dataset provides information on bird species in the Himalayas,
#' including their species names, genera, families, phylogenetic relationships, and
#' community composition across elevation bands.  This dataset is used to explore
#' elevational patterns of bird functional and phylogenetic diversity and the
#' ecological processes that structure bird communities.
#'
#' @format A list with three components:
#' \describe{
#'   \item{splist}{A data frame with 151 rows and 3 variables:
#'     \describe{
#'       \item{species}{Scientific name of the bird species.}
#'       \item{genus}{Genus of the bird species.}
#'       \item{family}{Family of the bird species.}
#'     }
#'   }
#'   \item{phy_species}{A phylogenetic tree (object of class "phylo") representing
#'   the evolutionary relationships among the bird species. It contains edge,
#'   edge.length, Nnode, tip.label, and node.label.}
#'   \item{com}{A community matrix representing the presence (1) or absence (0) of
#'   each bird species across 12 elevation bands (ele1 to ele12). The rows represent
#'   the elevation bands, and the columns represent the bird species.}
#' }
#'
#' @references
#'Ding, Z., Hu, H., Cadotte, M.W., Liang, J., Hu, Y., & Si, X. (2021). Elevational patterns of bird functional and phylogenetic structure
#'in the central Himalaya. Ecography, 44(9), 1403-1417. \doi{10.1111/ecog.05660}
#'
#' @examples
#' # Load the dataset
#' data(HimalayanBirds)
#' head(HimalayanBirds)
#'
"HimalayanBirds"
