% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assertions.R
\name{assert_unit_col}
\alias{assert_unit_col}
\alias{assert_unit_value}
\alias{assert_unit}
\title{Assert that a value may either be a column name in the data (first) or a
single unit value (second)}
\usage{
assert_unit_col(unit, data)

assert_unit_value(unit)

assert_unit(unit, data)
}
\arguments{
\item{unit}{The column name or unit value}

\item{data}{The data.frame that contains a column named \code{unit}}
}
\value{
\code{unit} with an attribute of "unit_type" that is either "column" or
"value", or \code{NULL} if \code{is.null(unit)}
}
\description{
Assert that a value may either be a column name in the data (first) or a
single unit value (second)
}
\section{Functions}{
\itemize{
\item \code{assert_unit_col()}: Assert that a column name contains a character string
(that could be a unit specification)

\item \code{assert_unit_value()}: Assert that a value may be a single unit

The function does not verify that it is a real unit like "ng/mL" only that it
is a single character string.

}}
