% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Parents_ordering.R
\name{is_order_abiding_Bsets}
\alias{is_order_abiding_Bsets}
\alias{is_order_abiding_Bsets_v}
\title{Check whether a certain order abides by the B-sets}
\usage{
is_order_abiding_Bsets(DAG, order_hash)

is_order_abiding_Bsets_v(B_sets, orderParents)
}
\arguments{
\item{DAG}{the considered DAG}

\item{order_hash}{the hashmaps of parents ordering}

\item{B_sets}{matrix of B-sets, assumed to be increasing.
This can be the output of \code{\link{find_B_sets_v}}
or of \code{\link{B_sets_make_unique}}.}

\item{orderParents}{a vector of characters, interpreted as the ordered
parents}
}
\value{
It returns `TRUE` if the order abides by the B-sets, and `FALSE` else.
}
\description{
Check whether a certain order abides by the B-sets
}
\examples{

DAG = create_empty_DAG(4)
DAG = bnlearn::set.arc(DAG, 'U1', 'U3')
DAG = bnlearn::set.arc(DAG, 'U2', 'U3')
DAG = bnlearn::set.arc(DAG, 'U3', 'U4')
DAG = bnlearn::set.arc(DAG, 'U1', 'U4')

order_hash = r2r::hashmap()
order_hash[['U3']] = c("U1", "U2")
order_hash[['U4']] = c("U1", "U3")
is_order_abiding_Bsets(DAG, order_hash)
order_hash[['U3']] = c("U2", "U1")
is_order_abiding_Bsets(DAG, order_hash)

}
