% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Metabolic_Equations.R
\name{weir_equation}
\alias{weir_equation}
\title{Calculate energy expenditure using the Weir equation}
\usage{
weir_equation(VO2, VCO2, epochSecs)
}
\arguments{
\item{VO2}{Oxygen consumption}

\item{VCO2}{Carbon dioxide production}

\item{epochSecs}{The averaging window of the metabolic data, in seconds}
}
\value{
numeric scalar indicating predicted energy expenditure from the Weir
  equation, based on the inputs
}
\description{
Calculate energy expenditure using the Weir equation
}
\examples{
weir_equation(3.5, 3.1, 60)

}
\references{
De V Weir, J. B. (1949). New methods for calculating metabolic
  rate with special reference to protein metabolism. The Journal of physiology,
  109(1-2), 1.
}
