% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate.residuals.R
\name{calculate.residuals}
\alias{calculate.residuals}
\title{Calculate residuals}
\usage{
calculate.residuals(x)
}
\arguments{
\item{x}{A numeric vector.}
}
\value{
A numeric vector of the same length as \code{x}.  Names are not retained.
}
\description{
Calculate residuals between quantiles of the input and quantiles of a Gaussian mixture model fitted to the data.
}
\examples{
# Generate fake data.
set.seed(1234);
x <- rgamma(
    n = 20,
    shape = 2,
    scale = 2
    );
names(x) <- paste(
    'Sample',
    seq_along(x),
    sep = '.'
    );
calculate.residuals(
    x = x
    );

}
