% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optM.R
\name{optM}
\alias{optM}
\title{optM function}
\usage{
optM(
  folder,
  orientagraph = F,
  tsv = NULL,
  method = "Evanno",
  skip = NULL,
  thresh = 0.05,
  ...
)
}
\arguments{
\item{folder}{A character string of the path to a directory containing .llik, .cov.gz and .modelcov.gz files produced by Treemix}

\item{orientagraph}{A logical indicating whether the files were produced from Treemix (FALSE) or OrientAGraph (TRUE). Default = F}

\item{tsv}{a string defining the name of the tab-delimited output file.
If NULL (default), then no data file is produced.}

\item{method}{a string containing the method to use, either "Evanno", "linear", or "SiZer".  Default is "Evanno".}

\item{skip}{a numeric vector of whole numbers indicating migration edges to ignore.  Useful when running Treemix on a prebuilt tree (skip = 0).  Default is NULL. Used to be called "ignore", which is now deprecated.}

\item{thresh}{a numeric value between 0 and 1 for the threshold to use for the proportion of increase
in likelihood that defines when a plateau is reached.  Default is 0.05 (5\%), only applicable for method = "linear".}

\item{...}{other options sent to the function "SiZer" - see the R package 'SiZer'}
}
\value{
If method = "Evanno": A data frame with 17 columns summarizing the results for each migration edge (rows).

The columns are: "m" - number of migration edges from the model; "runs" = number of iterations for "m";
"mean(Lm)" - mean log likelihood across runs; "sd(Lm)" - standard deviation of log likelihood across runs;
"min(Lm)" - minimum log likelihood across runs; "max(Lm)" - maximum log likelihood across runs;
"L'(m)" - first-order rate of change in log likelihood; "sdL'(m)" - standard deviation of first-order rate of change in log likelihood;
"minL'(m)" - minimum first-order rate of change in log likelihood; "maxL'(m)" - maximum first-order rate of change in log likelihood;
"L''(m)" - second-order rate of change in log likelihood; "sdL''(m)" - standard deviation of the second-order rate of change in log likelihood;
"minL''(m)" - minimum second-order rate of change in log likelihood; "maxL''(m)" - maximum second-order rate of change in log likelihood;
"Deltam" - the ad hoc deltaM statistic (secord order rate of change in log likelihood);
"mean(f)" - mean proportion of variation explained by the models; "sd(f)" - standard deviation of the proportion of variation explained by the models

If method = "linear": A list containing 5 elements:

$out - a data frame with the name of each model, the degrees of freedom (df), the Akaike information criterion (AIC), the deltaAIC, and the optimal estimate for m based on the model.

$PiecewiseLinear - the piecewise linear model object

$BentCable - the bent cable model object

$SimpleExponential - the simple exponential model object

$NonLinearLeastSquares - the NLS model object

If method = "SiZer": an object of class "SiZer" (see the R package 'SiZer' for more information)
}
\description{
Load a folder of .llik files from the program Treemix and determine the optimal number of migration edges to include
}
\examples{
# Load a folder of simulated test data for m = 3
folder <- system.file("extdata", package = "OptM")
test.optM = optM(folder)

# To view the various linear modeling estimates:
   # test.linear = optM(folder, method = "linear")

# To view the results from the SiZer package:
   # test.sizer = optM(folder, method = "SiZer")
}
\keyword{optM}
