% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/upset.R
\name{getEnrichmentsIntersection}
\alias{getEnrichmentsIntersection}
\title{getEnrichmentsIntersection}
\usage{
getEnrichmentsIntersection(
  study,
  modelID,
  annotationID,
  mustTests,
  notTests,
  sigValue,
  operator,
  type,
  libraries = NULL
)
}
\arguments{
\item{study}{An OmicNavigator study. Either an object of class \code{onStudy},
or the name of an installed study package.}

\item{modelID}{Filter by modelID}

\item{annotationID}{Filter by annotationID}

\item{mustTests}{The testIDs for which a featureID (or termID for enrichment)
must pass the filters}

\item{notTests}{The testIDs for which a featureID (or termID for enrichment)
must \bold{not} pass the filters. In other words, if a featureID passes the
filter for a testID specified in notTests, that featureID is removed from
the output}

\item{sigValue}{The numeric significance value to use as a cutoff for each
column}

\item{operator}{The comparison operators for each column, e.g. \code{"<"}}

\item{type}{Type of p-value: (\code{"nominal"} or \code{"adjusted"})}

\item{libraries}{Character vector of library directories to search for study
packages. If \code{NULL}, uses \code{.libPaths}.}
}
\value{
Returns a data frame with the enrichments, similar to
\code{\link{getEnrichmentsTable}}. Only rows that pass all the filters are
included.
}
\description{
getEnrichmentsIntersection
}
\seealso{
\code{\link{getEnrichmentsTable}}
}
