% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prune_ODRF.R
\name{prune.ODRF}
\alias{prune.ODRF}
\title{Pruning of class \code{ODRF}.}
\usage{
\method{prune}{ODRF}(obj, X, y, MaxDepth = 1, useOOB = TRUE, ...)
}
\arguments{
\item{obj}{An object of class \code{\link{ODRF}}.}

\item{X}{An n by d numeric matrix (preferable) or data frame is used to prune the object of class \code{ODRF}.}

\item{y}{A response vector of length n.}

\item{MaxDepth}{The maximum depth of the tree after pruning (Default 1).}

\item{useOOB}{Whether to use OOB for pruning (Default TRUE). Note that when \code{useOOB=TRUE}, \code{X} and \code{y} must be the training data in \code{\link{ODRF}}.}

\item{...}{Optional parameters to be passed to the low level function.}
}
\value{
An object of class \code{ODRF} and \code{prune.ODRF}.
\itemize{
\item{\code{ppForest} The same result as \code{ODRF}.}
\item{\code{pruneError} Error of test data or OOB after each pruning in each tree, misclassification rate (MR) for classification or mean square error (MSE) for regression.}
}
}
\description{
Prune \code{ODRF} from bottom to top with test data based on prediction error.
}
\examples{
# Classification with Oblique Decision Random Forest
data(seeds)
set.seed(221212)
train <- sample(1:209, 80)
train_data <- data.frame(seeds[train, ])
test_data <- data.frame(seeds[-train, ])
forest <- ODRF(varieties_of_wheat ~ ., train_data,
  split = "entropy", parallel = FALSE, ntrees = 50
)
prune_forest <- prune(forest, train_data[, -8], train_data[, 8])
pred <- predict(prune_forest, test_data[, -8])
# classification error
(mean(pred != test_data[, 8]))
\donttest{
# Regression with Oblique Decision Random Forest
data(body_fat)
set.seed(221212)
train <- sample(1:252, 80)
train_data <- data.frame(body_fat[train, ])
test_data <- data.frame(body_fat[-train, ])
index <- seq(floor(nrow(train_data) / 2))
forest <- ODRF(Density ~ ., train_data[index, ], split = "mse", parallel = FALSE, ntrees = 50)
prune_forest <- prune(forest, train_data[-index, -1], train_data[-index, 1], useOOB = FALSE)
pred <- predict(prune_forest, test_data[, -1])
# estimation error
mean((pred - test_data[, 1])^2)
}
}
\seealso{
\code{\link{ODRF}} \code{\link{online.ODRF}} \code{\link{prune.ODT}}
}
\keyword{forest}
\keyword{prune}
