% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pp.plot.r
\name{pp.plot}
\alias{pp.plot}
\title{Generic Probability-Probability(P–P) Plot Function}
\usage{
pp.plot(sample, pfun, params, fit.line = TRUE)
}
\arguments{
\item{sample}{A numeric vector of sample observations.}

\item{pfun}{A cumulative distribution function (CDF) corresponding to the
theoretical distribution (e.g., \code{pnorm}, \code{pexp}, or a custom CDF).}

\item{params}{A named list of distribution parameters
(e.g., \code{list(mean = 0, sd = 1)} or \code{list(alpha = 2, lambda = 1)}).}

\item{fit.line}{Logical; if \code{TRUE} (default), a red least-squares
regression line is added to the plot. Also, displays the regression
line equation and R² value on the plot.}
}
\value{
This function returns no value; it produces a P–P plot.
}
\description{
Generates a P–P (probability–probability) plot for any custom or built-in
probability distribution. The function compares the empirical probabilities
of the sample data with the theoretical probabilities computed from a
user-specified cumulative distribution function (CDF).
}
\details{
The P–P plot is used to assess how closely the empirical distribution of
a dataset matches a specified theoretical distribution. The points should
ideally fall along the 45° reference line if the model fits well. 

Requires user-defined function \code{'pfun'} for the CDF of the 
user-defined continuous distribution.

Missing values in the sample are automatically removed with a warning.
}
\examples{
# Example 1: Exponential distribution
set.seed(123)
x <- rexp(100, rate = 2)
pp.plot(x, pexp, list(rate = 2))

# Example 2: Customizing the fitted line
pp.plot(x, pexp, list(rate = 2),
              fit.line = TRUE)

# Example 3: Without regression line
pp.plot(x, pexp, list(rate = 2), fit.line = FALSE)

# Example 4: Display regression equation and R² value
pp.plot(x, pexp, list(rate = 2))

# Example 5: For a user defined distribution
# Exponentiated Exponential Power (EEP) Distribution
# Data
x <- waiting
pp.plot(x,
      params = list(alpha=0.3407, lambda=0.6068, theta=7.6150),
      pfun = pgen.exp.power, fit.line=TRUE)

}
