% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LogisInvExp.r
\name{LogisInvExp}
\alias{LogisInvExp}
\alias{dlogis.inv.exp}
\alias{plogis.inv.exp}
\alias{qlogis.inv.exp}
\alias{rlogis.inv.exp}
\alias{hlogis.inv.exp}
\title{Logistic Inverse Exponential Distribution}
\usage{
dlogis.inv.exp(x, alpha, lambda, log = FALSE)
plogis.inv.exp(q, alpha, lambda, lower.tail = TRUE, log.p = FALSE)
qlogis.inv.exp(p, alpha, lambda, lower.tail = TRUE, log.p = FALSE)
rlogis.inv.exp(n, alpha, lambda)
hlogis.inv.exp(x, alpha, lambda)
}
\arguments{
\item{x, q}{numeric vector of quantiles (x, q)}

\item{alpha}{positive numeric parameter}

\item{lambda}{positive numeric parameter}

\item{log}{logical; if TRUE, returns log-density}

\item{lower.tail}{logical; if TRUE (default), probabilities are 
\eqn{P[X \le x]} otherwise, \eqn{P[X > x]}.}

\item{log.p}{logical; if TRUE, probabilities are given as log(p)}

\item{p}{numeric vector of probabilities (0 < p < 1)}

\item{n}{number of observations (integer > 0)}
}
\value{
\itemize{
  \item \code{dlogis.inv.exp}: numeric vector of (log-)densities
  \item \code{plogis.inv.exp}: numeric vector of probabilities
  \item \code{qlogis.inv.exp}: numeric vector of quantiles
  \item \code{rlogis.inv.exp}: numeric vector of random variates
  \item \code{hlogis.inv.exp}: numeric vector of hazard values
}
}
\description{
Provides density, distribution, quantile, random generation,
and hazard functions for the Logistic Inverse Exponential distribution.
}
\details{
The Logistic Inverse Exponential distribution is parameterized by the parameters
\eqn{\alpha > 0} and \eqn{\lambda > 0}.


The Logistic Inverse Exponential distribution has CDF:

\deqn{
F(x; \alpha, \lambda) =
\quad \frac{1}{1+[\exp \{\lambda / x\}-1]^\alpha} 
\, ; \quad x > 0.
}

where \eqn{\alpha} and \eqn{\lambda} are the parameters.

Available functions are:
\itemize{
  \item \code{dlogis.inv.exp()} — Density function
  \item \code{plogis.inv.exp()} — Distribution function
  \item \code{qlogis.inv.exp()} — Quantile function
  \item \code{rlogis.inv.exp()} — Random generation
  \item \code{hlogis.inv.exp()} — Hazard function
}
}
\examples{
x <- seq(0.1, 10, 0.5)
dlogis.inv.exp(x, 2.5, 1.5)
plogis.inv.exp(x, 2.5, 1.5)
qlogis.inv.exp(0.5, 2.5, 1.5)
rlogis.inv.exp(10, 2.5, 1.5)
hlogis.inv.exp(x, 2.5, 1.5)

# Data
x <- stress31
# ML estimates
params = list(alpha=7.6230, lambda=91.7136)
#P–P (probability–probability) plot
pp.plot(x, params = params, pfun = plogis.inv.exp, fit.line=TRUE)

#Q-Q (quantile–quantile) plot 
qq.plot(x, params = params, qfun = qlogis.inv.exp, fit.line=TRUE)

# Goodness-of-Fit(GoF) and Model Diagnostics 
out <- gofic(x, params = params,
             dfun = dlogis.inv.exp, pfun=plogis.inv.exp, plot=FALSE)
print.gofic(out)

}
\references{
Chaudhary, A.K., & Kumar, V. (2020). 
Logistic Inverse Exponential Distribution with Properties and Applications. 
\emph{International Journal of Mathematics Trends and Technology}, 
\bold{66(10)}, 151--162.  
\doi{10.14445/22315373/IJMTT-V66I10P518}
}
