% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LindleyHC.r
\name{LindleyHC}
\alias{LindleyHC}
\alias{dlindley.HC}
\alias{plindley.HC}
\alias{qlindley.HC}
\alias{rlindley.HC}
\alias{hlindley.HC}
\title{Lindley Half-Cauchy(LHC) Distribution}
\usage{
dlindley.HC(x, lambda, theta, log = FALSE)
plindley.HC(q, lambda, theta, lower.tail = TRUE, log.p = FALSE)
qlindley.HC(p, lambda, theta, lower.tail = TRUE, log.p = FALSE)
rlindley.HC(n, lambda, theta)
hlindley.HC(x, lambda, theta)
}
\arguments{
\item{x, q}{numeric vector of quantiles (x, q)}

\item{lambda}{positive numeric parameter}

\item{theta}{positive numeric parameter}

\item{log}{logical; if TRUE, returns log-density}

\item{lower.tail}{logical; if TRUE (default), probabilities are 
\eqn{P[X \le x]} otherwise, \eqn{P[X > x]}.}

\item{log.p}{logical; if TRUE, probabilities are given as log(p)}

\item{p}{numeric vector of probabilities (0 < p < 1)}

\item{n}{number of observations (integer > 0)}
}
\value{
\itemize{
  \item \code{dlindley.HC}: numeric vector of (log-)densities
  \item \code{plindley.HC}: numeric vector of probabilities
  \item \code{qlindley.HC}: numeric vector of quantiles
  \item \code{rlindley.HC}: numeric vector of random variates
  \item \code{hlindley.HC}: numeric vector of hazard values
}
}
\description{
Provides density, distribution, quantile, random generation,
and hazard functions for the Lindley Half-Cauchy distribution.
}
\details{
The Lindley Half-Cauchy distribution is parameterized by the parameters
\eqn{\lambda > 0}, and \eqn{\theta > 0}.


The Lindley Half-Cauchy distribution has CDF:

\deqn{
F(x; \lambda, \theta) =
1 - {\left\{ {1 - \frac{2}{\pi }{{\tan }^{ - 1}}\left( {\frac{x}{\lambda }} \right)} \right\}
^\theta }\left\{ {1 - \left( {\frac{\theta }{{1 + \theta }}} \right)
\ln \left[ {1 - \frac{2}{\pi }{{\tan }^{ - 1}}\left( {\frac{x}{\lambda }} \right)} \right]}
\right\} \; ;\;x > 0.
}

where\eqn{\lambda} and \eqn{\theta} are the parameters.
}
\examples{
x <- seq(1, 10, 0.5)
dlindley.HC(x, 0.5, 1.5)
plindley.HC(x, 0.5, 1.5)
qlindley.HC(0.5, 0.5, 1.5)
rlindley.HC(10, 0.5, 1.5)
hlindley.HC(x, 0.5, 1.5)

# Data
x <- reactorpump
# ML estimates
params = list(lambda=0.5479, theta=1.2766)
#P–P (probability–probability) plot
pp.plot(x, params = params, pfun = plindley.HC, fit.line=TRUE)

#Q-Q (quantile–quantile) plot 
qq.plot(x, params = params, qfun = qlindley.HC, fit.line=TRUE)

# Goodness-of-Fit(GoF) and Model Diagnostics 
out <- gofic(x, params = params,
             dfun = dlindley.HC, pfun=plindley.HC, plot=FALSE)
print.gofic(out)

}
\references{
Chaudhary, A.K. & Kumar, V. (2020). 
Lindley Half Cauchy Distribution: Properties and Applications. 
\emph{International Journal For Research in Applied Science & Engineering 
Technology (IJRASET)},  \bold{8(9)}, 1232--1242. \doi{10.22214/ijraset.2020.31745}
}
