% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LindleyGompertz.r
\name{LindleyGompertz}
\alias{LindleyGompertz}
\alias{dlindley.gpz}
\alias{plindley.gpz}
\alias{qlindley.gpz}
\alias{rlindley.gpz}
\alias{hlindley.gpz}
\title{Lindley-Gompertz Distribution}
\usage{
dlindley.gpz(x, alpha, lambda, theta, log = FALSE)
plindley.gpz(q, alpha, lambda, theta, lower.tail = TRUE, log.p = FALSE)
qlindley.gpz(p, alpha, lambda, theta, lower.tail = TRUE, log.p = FALSE)
rlindley.gpz(n, alpha, lambda, theta)
hlindley.gpz(x, alpha, lambda, theta)
}
\arguments{
\item{x, q}{numeric vector of quantiles (x, q)}

\item{alpha}{positive numeric parameter}

\item{lambda}{positive numeric parameter}

\item{theta}{positive numeric parameter}

\item{log}{logical; if TRUE, returns log-density}

\item{lower.tail}{logical; if TRUE (default), probabilities are 
\eqn{P[X \le x]} otherwise, \eqn{P[X > x]}.}

\item{log.p}{logical; if TRUE, probabilities are given as log(p)}

\item{p}{numeric vector of probabilities (0 < p < 1)}

\item{n}{number of observations (integer > 0)}
}
\value{
\itemize{
  \item \code{dlindley.gpz}: numeric vector of (log-)densities
  \item \code{plindley.gpz}: numeric vector of probabilities
  \item \code{qlindley.gpz}: numeric vector of quantiles
  \item \code{rlindley.gpz}: numeric vector of random variates
  \item \code{hlindley.gpz}: numeric vector of hazard values
}
}
\description{
Provides density, distribution, quantile, random generation,
and hazard functions for the Lindley-Gompertz distribution.
}
\details{
The Lindley-Gompertz distribution is parameterized by the parameters
\eqn{\alpha > 0}, \eqn{\lambda > 0}, and \eqn{\theta > 0}.


The Lindley-Gompertz distribution has CDF:

\deqn{
F(x; \alpha, \lambda, \theta) =
\left( 1 - \exp\left\{ \frac{\lambda}{\alpha}
\left( 1 - \exp(\alpha x) \right) \right\} \right)^{\theta}
\left[ 1 - \frac{\theta}{1 + \theta}
\log\left\{ 1 - \exp\left( \frac{\lambda}{\alpha}
\left( 1 - \exp(\alpha x) \right) \right) \right\} \right],
\quad x > 0.
}

where \eqn{\alpha}, \eqn{\lambda}, and \eqn{\theta} are the parameters.
}
\examples{
x <- seq(1, 10, 0.5)
dlindley.gpz(x, 0.1, 0.5, 1.5)
plindley.gpz(x, 0.1, 0.5, 1.5)
qlindley.gpz(0.5, 0.1, 0.5, 1.5)
rlindley.gpz(10, 0.1, 0.5, 1.5)
hlindley.gpz(x, 0.1, 0.5, 1.5)

# Data
x <- conductors
# ML estimates
params = list(alpha=0.1765, lambda=0.2051, theta=11.4574)
#P–P (probability–probability) plot
pp.plot(x, params = params, pfun = plindley.gpz, fit.line=TRUE)

#Q-Q (quantile–quantile) plot 
qq.plot(x, params = params, qfun = qlindley.gpz, fit.line=TRUE)

# Goodness-of-Fit(GoF) and Model Diagnostics 
out <- gofic(x, params = params,
             dfun = dlindley.gpz, pfun=plindley.gpz, plot=FALSE)
print.gofic(out)

}
\references{
Joshi, R. K., & Kumar, V. (2020). 
Lindley Gompertz distribution with properties and application. 
\emph{International Journal of Statistics and Applied Mathematics}, 
\bold{5(6)}, 28--37. \doi{10.22271/maths.2020.v5.i6a.610}
}
