% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{quality_filter}
\alias{quality_filter}
\title{Filter Data by Quality Metrics}
\usage{
quality_filter(
  data,
  variable_column,
  value_column,
  grouping_columns,
  quality_threshold,
  min_observations,
  verbose
)
}
\arguments{
\item{data}{Data frame to filter}

\item{variable_column}{Column name containing variable identifiers}

\item{value_column}{Column name containing values to assess}

\item{grouping_columns}{Vector of column names for grouping}

\item{quality_threshold}{Minimum data completeness ratio (0-1)}

\item{min_observations}{Minimum number of observations required}

\item{verbose}{Whether to print filtering results}
}
\value{
Filtered data frame
}
\description{
Filters variables and groups based on observation counts and data completeness
}
\examples{
test_data <- data.frame(
  Variable = rep(paste0("V", 1:5), each = 20),
  Value = rnorm(100),
  Group = rep(c("A", "B"), 50)
)
filtered <- quality_filter(test_data, "Variable", "Value", "Group", 
                           0.8, 5, FALSE)

}
