#' Summary Method for NNMoMoData Objects
#'
#' Method for printing the summary of \code{\link{NNMoMoData}}. Gives detailed
#' infofmation about the object.
#'
#' @param object An object of class \code{NNMoMoData}.
#' @param ... Further arguments passed to or from other methods.
#'
#' @return Displays a summary of the \code{NNMoMoData} object in the console.
#'
#' @export
summary.NNMoMoData <- function(object, ...) {
  cat("Summary of NNMoMoData object:\n")
  cat("  Number of countries :", length(table(object$country)), "\n")
  cat(
    "  Countries           :",
    paste(names(table(object$country)), collapse = ", "),
    "\n"
  )
  cat(
    "  Sexes               :",
    paste(names(table(object$sex)), collapse = ", "),
    "\n"
  )
  cat("  Years               :", min(object$year), "-", max(object$year), "\n")

  rate_cols <- grep("^rate_", names(object), value = TRUE)
  ages <- as.integer(sub("rate_", "", rate_cols))
  cat("  Ages                :", min(ages), "-", max(ages), "\n")

  cat("  Total rows          :", nrow(object), "\n")
}
