% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CI_mean.R
\name{Navae_ci_mean}
\alias{Navae_ci_mean}
\title{Compute NAVAE CI for the expectation based on empirical mean estimator
and Berry-Esseen (BE) or Edgeworth Expansions (EE) bounds}
\usage{
Navae_ci_mean(
  data,
  alpha = 0.05,
  a = "best",
  bound_K = NULL,
  known_variance = NULL,
  param_BE_EE = list(choice = "best", setup = list(continuity = FALSE, iid = TRUE,
    no_skewness = FALSE), regularity = list(C0 = 1, p = 2), eps = 0.1),
  na.rm = FALSE
)
}
\arguments{
\item{data}{vector of univariate observations.}

\item{alpha}{this is 1 minus the confidence level of the CI; in other words,
the nominal level is \code{1 - alpha}.
By default, \code{alpha} is set to \code{0.05}, yielding a \eqn{95\%} CI.}

\item{a}{the free parameter \eqn{a} (or \eqn{a_n}) of the interval.
It must be either \itemize{
  \item a numeric value larger than 1, taken as the value of \eqn{a},

  \item the character value \code{"best"} which is the default. It selects the
  \code{a} such that the confidence interval has the smallest length.

  \item a list such as \code{list(power_of_n_for_b = -2/5)} giving a way to
  compute \code{a} as \code{a = 1 + n^power_of_n_for_b}. Note that \code{-2/5}
  is the optimal (theoretical) rate.
}}

\item{bound_K}{bound on the kurtosis K_4(theta) of the distribution of the
observations that are assumed to be i.i.d.
The choice of \code{9} covers most "usual" distributions.
If the argument is not provided (default argument \code{NULL}), the value used
is the plug-in counterpart \eqn{\widehat{K}}, that is, the empirical kurtosis
of the observations.}

\item{known_variance}{by default NULL, in this case, the function computes
the CI in the general case with an unknown variance (which is estimated).
Otherwise, a scalar numeric vector equal to the (assumed/known) variance.
(NB: if the option is used, one must provide the variance and not the standard
deviation.)}

\item{param_BE_EE}{parameters to compute the BE or EE bound \eqn{\delta_n} used
to construct the confidence interval.
If \code{param_BE_EE} is exactly equal to \code{"BE"}, then the bound used is
the best up-to-date BE bound from Shevtsova (2013) combined with a convexity
inequality.
Otherwise, \code{param_BE_EE} is a list of four objects: \itemize{
  \item \code{choice}:
  If equal to \code{"EE"}, the bound used is Derumigny et al. (2023)'s bound
  computed using the parameters specified by the rest of \code{param_BE_EE},
  namely
  \item \code{setup}: itself a logical vector of size 3,
  \item \code{regularity}: itself a list of length up to 3,
  \item \code{eps}: value between 0 and 1/3,
}
as described in the arguments of the function
\code{BoundEdgeworth::\link[BoundEdgeworth]{Bound_EE1}}.
Together, they specify the bounds and assumptions used to compute the
bound \eqn{\delta_n} from Derumigny et al. (2023).
Finally, if \code{choice} is equal to \code{"best"}, the bound used is the minimum
between the previous one (with \code{choice = "EE"}) and the bound \code{"BE"}.

By default, following Remark 3.3 of the article, \code{"best"} is used and
Derumigny et al. (2025)'s bounds is computed assuming i.i.d data and no other
regularity assumptions (continuous or unskewed distribution) and the bound on
kurtosis used is the one specified in the previous the argument \code{bound_K}.}

\item{na.rm}{logical, should missing values in \code{data} be removed?}
}
\value{
\code{Navae_ci_mean} returns an object of class
\code{NAVAE_CI_Mean}, containing:
\itemize{
  \item \code{ci_navae}: the NAVAE confidence interval

  \item \code{ci_asymp}: the classical "asymptotic" CI based on CLT
  (as a comparison)

  \item \code{indicator_R_regime}: 1 if we are in the \eqn{\mathbb{R}} regime
  and 0 else.

  \item \code{delta_n}, \code{delta_n_from}: respectively the numerical value
  of the bound \eqn{delta_n} used, and a character string \code{BE} or \code{EE}
  indicating which type of inequality was used.

  \item \code{minimal_alpha_to_exit_R_regime}: the minimal alpha to exit the
  \eqn{\mathbb{R}} regime.

  \item \code{bound_K_value}, \code{bound_K_method}: the value K used and the
  method to compute it.
}
}
\description{
Compute NAVAE CI for the expectation based on empirical mean estimator
and Berry-Esseen (BE) or Edgeworth Expansions (EE) bounds
}
\examples{
n = 10000
x = rexp(n, 1)
Navae_ci_mean(x, bound_K = 9, alpha = 0.2)

Navae_ci_mean(x, bound_K = 9, alpha = 0.2, a = 1 + n^(-2/5))
# Same as:
Navae_ci_mean(x, bound_K = 9, alpha = 0.2, a = list(power_of_n_for_b = -2/5))

# plug-in for K ( = data-driven choice of K)
Navae_ci_mean(x, alpha = 0.2)

listParams1 = list(
  choice = "best",
  setup = list(continuity = FALSE, iid = TRUE, no_skewness = FALSE),
  regularity = list(C0 = 1, p = 2),
  eps = 0.1)

listParams2 = list(
  choice = "best",
  setup = list(continuity = TRUE, iid = TRUE, no_skewness = FALSE),
  regularity = list(kappa = 0.99), eps = 0.1)

Navae_ci_mean(x, alpha = 0.1, param_BE_EE = listParams1)
Navae_ci_mean(x, alpha = 0.1, param_BE_EE = listParams2)
Navae_ci_mean(x, alpha = 0.05, param_BE_EE = listParams1)
Navae_ci_mean(x, alpha = 0.05, param_BE_EE = listParams2)

}
\references{
For the confidence interval:

Derumigny, A., Girard, L., & Guyonvarch, Y. (2025).
Can we have it all?
Non-asymptotically valid and asymptotically exact confidence intervals
for expectations and linear regressions.
ArXiv preprint, \doi{10.48550/arXiv.2507.16776}.

For the underlying Edgeworth expansion bounds:

Derumigny A., Girard L., and Guyonvarch Y. (2023).
Explicit non-asymptotic bounds for the distance to the first-order Edgeworth expansion,
Sankhya A. \doi{10.1007/s13171-023-00320-y}
ArXiv preprint: \doi{10.48550/arxiv.2101.05780}.
}
\seealso{
\code{\link{Navae_ci_ols}} the corresponding function for the linear
regression case.

Some methods for the returned object: \code{\link{print.NAVAE_CI_Mean}} and
\code{\link{as.data.frame.NAVAE_CI_Mean}}.
}
