% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tune_param_eNAP.R
\name{tune_param_eNAP}
\alias{tune_param_eNAP}
\title{Calibrate (a, b) for eNAP prior}
\usage{
tune_param_eNAP(
  s_EC2,
  s_EC1,
  s_C2C1,
  tau0 = 1000,
  delta = 0.5,
  t1 = 0.999,
  t0 = 0.05,
  clip_a = c(-5, -0.5),
  clip_b = c(1e-05, 50),
  exact = FALSE,
  y_EC1 = -0.5,
  y_C2C1 = -0.5,
  mu0 = 0,
  sigma2_hat = NULL,
  verbose = FALSE
)
}
\arguments{
\item{s_EC2, s_EC1, s_C2C1}{Sampling variances for post-SoC change period (E vs. C2), pre-SoC change period of current trial (E vs. C1 trial) and external trial (C2 vs. C1 trial)}

\item{delta}{Positive scalar; Clinically significant difference on the log-HR scale such that direct and indirect evidence should be considered as strongly inconsistent.}

\item{t1, t0}{Positive scalar; Calibration targets at consisntency and strongly inconsistency: \eqn{w'(0)=t1} (near 1; default 0.99), \eqn{w'(\delta)=t0} (near 0; default 0.05).}

\item{clip_a, clip_b}{Numeric Vector of Legnth 2: Minimum and maximum caps for tuning parameters (a,b), by default clip_a=(-5,0.5) and clip_b=(0,50)}

\item{exact}{Logical (TRUE/FALSE); If TRUE, require the exact solution for parameter (a,b), which further requires more parameters input}

\item{y_EC1, y_C2C1}{Log-HR for pre-SoC change period and external trial, required only if exact=TRUE}

\item{mu0, tau0}{Mean and variance for the vague component, by default mu0=0 and tau0=1000.}

\item{sigma2_hat}{Positive scalar, required only for multiple external trials setting, leave blank if use default REML estimate, otherwise provide user-specified value}

\item{verbose}{Logical; print diagnostics.}
}
\value{
list with \code{a}, \code{b}, \code{mode} ("FE" or "RE"), and simple \code{check} summary.
}
\description{
Calibrates the tuning parameters \eqn{(a,b)} of the elastic NAP prior. This function supports both the one external trial setting
and multiple external trials setting:
\itemize{
\item \emph{Single external trial}  provide y_C2C1 and s_C2C1 as scalars.
\item \emph{Multiple external trials} provide y_C2C1 and s_C2C1 as vectors of same lengths. by default the cross-trial variance
will be automatically calculated by REML, otherwise please provide the cross-trial variance as input parameter: sigma2_hat
}
}
\details{
\strong{Calibration procedure:}
\itemize{
\item \emph{Consistency case (\eqn{Z = 0}).} Enforce near-full borrowing at exact
consistency by solving \eqn{w'(Z = 0) = t_1} for \eqn{a}.

\item \emph{Strong inconsistency case (\eqn{Z(\delta)=\frac{|\delta|}{\sqrt{s_{E,C_2}+s_{E,C_1}+s_{C_2,C_1}}}).}} Enforce minimal borrowing
at a clinically significant difference by targeting the \emph{updated}
weight \eqn{w'(Z(\delta)) = t_0}, with calibrated a from step 1, solve for \eqn{b}.
}
For further details, see the original NAP paper by Zhang and et al. (manuscript).
}
\examples{
s_EC2 <- 0.2^2; s_EC1 <- 0.18^2; s_C2C1 <- 0.18^2
tau0 <- 1000

# One external trial setting
tune_param_eNAP(
  s_EC2,s_EC1,s_C2C1, tau0=1000,
  delta=0.5, t1 = 0.999, t0 = 0.05)

# Multiple external trials setting
s_C2C1=c(0.19^2,0.18^2,0.20^2)
y_C2C1=c(-0.5,-0.45,-0.6)
tune_param_eNAP(
  s_EC2,s_EC1,s_C2C1, tau0=10,
  delta=0.5, t1 = 0.999, t0 = 0.05,
  exact=TRUE,y_EC1=-0.8,y_C2C1=y_C2C1)

}
