% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mk_test_func.R
\name{mkComponent}
\alias{mkComponent}
\title{Component Wise Mann-Kendall Test Statistic}
\usage{
mkComponent(data)
}
\arguments{
\item{data}{Numeric matrix representing the data series, each column should be a component.}
}
\value{
A numeric vector with the univariate MK test statistic for each component of the data series.
}
\description{
The functions performs the univariate Mann-Kendall test statistic
to each variable of a data series.
}
\details{
Let \eqn{M} be a dataset of \eqn{m} components and \eqn{n} observations.
The Mann-Kendall's (MK) test statistic for a variable of the dataset \eqn{M^{(u)}} is given by:

\deqn{M^{(u)} = \sum_{1 \leq i \leq j \leq n} sgn(x_j^{(u)} - x_i^{(u)})}
where \eqn{sgn(\cdot)} is the sign function:
\deqn{
sgn(x)=\begin{cases}
-1 \quad \text{if } x<0, \\
0 \quad \text{if } x=0, \\
+1 \quad \text{if } x>0
\end{cases}
}

This test statistic is normal distributed, with mean and variance:
\deqn{E(M^{(u)}) = 0},
\deqn{\text{var}(M^{(u)}) = \frac{n(n-1)(2n+5)}{18}}
}
\examples{
# Sample data (Both marginal distributions have trend):
dataMarginalTrend <- generate_data("marginalTrend", n = 50)

# Perform multivariate MK test on sample data:
mkComponent(dataMarginalTrend)

}
\references{
\itemize{
\item Hamed, K.H., Rao, A.R., 1998. A modified Mann-Kendall trend test for autocorrelated
data. J. Hydrol. 204 (1–4), 182–196.
\item Kendall, M., (1975). Rank Correlation Methods; Griffin: London.
}
}
