% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PairComp.R
\name{PairComp}
\alias{PairComp}
\title{Comparacoes multiplas multivariadas}
\usage{
PairComp(MANOVA,adjust="bonferroni",test="Pillai",Sig=0.05)
}
\arguments{
\item{MANOVA}{Resultado da funcao MANOVA}

\item{adjust}{Ajuste da significancia para o teste de comparacao multipla.
Pode ser: "holm", "hochberg", "hommel", "bonferroni", "BH", "BY",
  "fdr" ou "none".}

\item{test}{Teste considerado na MANOVA. Pode ser:"Pillai", "Wilks",
"Hotelling-Lawley" ou "Roy"}

\item{Sig}{Significancia a ser considerado. Default e 0.05.}
}
\value{
A funcao as comparações multiplas para os tratamentos.
}
\description{
Esta funcao retorna o resultado da comparacao multiplas (dois a dois)
com abordagem multivariada.
}
\examples{
\donttest{
#Delineamento inteiramente casualizado (DIC)
data("Dados.DIC")
Res=MANOVA(Dados.DIC,1)
PairComp(Res)

#Delineamento em blocos casualizados (DBC)
data(Dados.DBC)
Res=MANOVA(Dados.DBC,2)
PairComp(Res)

#Delineamento em quadrado latino (DQL)
data(Dados.DQL)
Res=MANOVA(Dados.DQL,3)
PairComp(Res)

#Esquema fatorial duplo em DIC
data(Dados.Fat2.DIC)
Res=MANOVA(Dados.Fat2.DIC,4)
PairComp(Res)

#Esquema fatorial duplo em DBC
data(Dados.Fat2.DBC)
Res=MANOVA(Dados.Fat2.DBC,5)
PairComp(Res)

#' #Esquema fatorial triplo em DIC
data(Dados.Fat3.DIC)
Res=MANOVA(Dados.Fat3.DIC,6)
PairComp(Res)

#Esquema fatorial triplo em DBC
data(Dados.Fat3.DBC)
Res=MANOVA(Dados.Fat3.DBC,7)
PairComp(Res)
}

}
\references{
PlayList "Curso de Analise Multivariada":
 https://www.youtube.com/playlist?list=PLvth1ZcREyK72M3lFl7kBaHiVh5W53mlR


CRUZ, C.D. and CARNEIRO, P.C.S.  Modelos biometricos aplicados ao
  melhoramento genetico. 3nd Edition. Vicosa, UFV, v.2, 2014. 668p.  (ISBN: 8572691510)

Da Silva, A.R.; Malafaia, G.; Menezes, I.P.P. (2017) biotools: an R function
to predict spatial gene diversity via an individual-based approach. Genetics
and Molecular Research, 16: gmr16029655.

FERREIRA, D.F. Estatistica Multivariada. (2018) 3ed. UFLA. 624p. (ISBN 13:978 8581270630)

Krzanowski, W. J. (1988) Principles of Multivariate Analysis. A User's Perspective. Oxford.

HAIR, J.F. Multivariate Data Analysis.  (2016) 6ed. Pearson Prentice HalL.
  (ISBN 13:978 0138132637)
}
\seealso{
\code{\link{lm}}, \code{\link{manova}}
}
