% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GraphicalOutputs.R
\name{IRFandGIRFgraphs}
\alias{IRFandGIRFgraphs}
\title{IRF and GIRF graphs for all models}
\usage{
IRFandGIRFgraphs(
  ModelType,
  NumOut,
  WishPdynamicsgraphs,
  WishYieldsgraphs,
  IRFhoriz,
  PathsGraphs,
  OutputType,
  Economies,
  Folder2save,
  verbose
)
}
\arguments{
\item{ModelType}{character. Estimated model type.Permissible choices: "JPS original", "JPS global", "GVAR single", "JPS multi", "GVAR multi", "JLL original", "JLL No DomUnit", "JLL joint Sigma".}

\item{NumOut}{list. Computed outputs containing model fit, IRFs, FEVDs, GIRFs, GFEVDs and term premia.}

\item{WishPdynamicsgraphs}{logical. Set TRUE to generate risk factor graphs, FALSE otherwise.}

\item{WishYieldsgraphs}{logical. Set TRUE to generate bond yield graphs, FALSE otherwise.}

\item{IRFhoriz}{integer. Desired horizon of analysis for the IRFs.}

\item{PathsGraphs}{character. Path of the folder in which the graphs will be saved.}

\item{OutputType}{character. Available options: "IRF", "GIRF", "IRF Ortho", "GIRF Ortho".}

\item{Economies}{character vector. Names of the \code{C} economies included in the system.}

\item{Folder2save}{character. Folder path where the outputs will be stored.}

\item{verbose}{logical. Flag controlling function messaging.}
}
\description{
IRF and GIRF graphs for all models
}
\section{Available Methods}{

- `autoplot(object, type = "IRF_Factor")`, `autoplot(object, type = "IRF_Yields")`,
  `autoplot(object, type = "GIRF_Yields")`, `autoplot(object, type = "GIRF_Yields")`.
  For JLL-based models: `autoplot(object, type = "IRF_Factor-_Ortho")`,\cr
  `autoplot(object, type = "IRF_Yields_Ortho")`, `autoplot(object, type = "GIRF_Yields_Ortho")`,
  `autoplot(object, type = "GIRF_Yields_Ortho")`.
}

\examples{
data("NumOutEx")
ModelType <- "JPS original"
Economy <- "Brazil"
IRFhoriz <- 20
irf_Out <- IRFandGIRFgraphs(ModelType, NumOutEx,
  WishPdynamicsgraphs = FALSE, WishYieldsgraphs = TRUE, IRFhoriz,
  PathsGraphs = NULL, OutputType = "GIRF", Economy, Folder2save = NULL,
  verbose = FALSE
)

}
