% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mixtures.R
\name{mixtureSummaryTable}
\alias{mixtureSummaryTable}
\title{Create a summary table of Mplus mixture models}
\usage{
mixtureSummaryTable(
  modelList,
  keepCols = c("Title", "Classes", "Warnings", "AIC", "BIC", "aBIC", "Entropy",
    "T11_VLMR_PValue", "T11_LMR_PValue", "BLRT_PValue", "min_N", "max_N", "min_prob",
    "max_prob"),
  sortBy = NULL,
  ...
)
}
\arguments{
\item{modelList}{A list of models returned from the
\code{extractModelSummaries} function.}

\item{keepCols}{A vector of character strings indicating which
columns/variables to display in the summary. Only columns included in this
list will be displayed (all others excluded). By default, \code{keepCols} is:
\code{c("Title", "Classes", "Warnings", "AIC", "BIC", "aBIC","Entropy",
"T11_VLMR_PValue", "T11_LMR_PValue", "BLRT_PValue", "min_N", "max_N",
"min_prob", "max_prob")}.}

\item{sortBy}{Field name (as character string) by which to sort the
table. Typically an information criterion (e.g., "AIC" or "BIC") is used to
sort the table. Defaults to "AICC". Set to NULL by default, so the table is
ordered by increasing number of classes.}

\item{...}{Arguments passed to \code{\link{SummaryTable}}.}
}
\value{
An object of class data.frame.
}
\description{
Creates a summary table of model fit statistics and relevant diagnostic
information for a list of mixture models. Default statistics reported are in
line with published guidelines (see Jung & Wickrama, 2008; Nylund et al.,
2007): \code{c("Title", "Classes", "Warnings", "AIC", "BIC", "aBIC",
"Entropy", "T11_VLMR_PValue", "T11_LMR_PValue", "BLRT_PValue", "min_N",
"max_N", "min_prob", "max_prob")}. The table is customizable using the
\code{keepCols} parameter, which is passed through to \link{SummaryTable}.
}
\note{
This function is partially a wrapper around SummaryTable, with
enhancements for summarizing mixture models.
}
\examples{
\dontrun{
res <- createMixtures(classes = 1:2, filename_stem = "iris", rdata = iris,
               OUTPUT = "tech11 tech14;",
               run = 1L)
mixtureSummaryTable(res)
}
}
\seealso{
\code{\link{SummaryTable}}
}
\author{
Caspar J. van Lissa
}
\keyword{mixture}
\keyword{mplus}
